// CHECKSTYLE:OFF

package org.jenkinsci.plugins.oic.properties;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code AllowedTokenExpirationClockSkew.DisplayName}: {@code Token
     * Expiry Expiration Clock Skew}.
     * 
     * @return
     *     {@code Token Expiry Expiration Clock Skew}
     */
    public static String AllowedTokenExpirationClockSkew_DisplayName() {
        return holder.format("AllowedTokenExpirationClockSkew.DisplayName");
    }

    /**
     * Key {@code AllowedTokenExpirationClockSkew.DisplayName}: {@code Token
     * Expiry Expiration Clock Skew}.
     * 
     * @return
     *     {@code Token Expiry Expiration Clock Skew}
     */
    public static Localizable _AllowedTokenExpirationClockSkew_DisplayName() {
        return new Localizable(holder, "AllowedTokenExpirationClockSkew.DisplayName");
    }

    /**
     * Key {@code LogoutQueryParameters.DisplayName}: {@code Query Parameters
     * for Logout Endpoint}.
     * 
     * @return
     *     {@code Query Parameters for Logout Endpoint}
     */
    public static String LogoutQueryParameters_DisplayName() {
        return holder.format("LogoutQueryParameters.DisplayName");
    }

    /**
     * Key {@code LogoutQueryParameters.DisplayName}: {@code Query Parameters
     * for Logout Endpoint}.
     * 
     * @return
     *     {@code Query Parameters for Logout Endpoint}
     */
    public static Localizable _LogoutQueryParameters_DisplayName() {
        return new Localizable(holder, "LogoutQueryParameters.DisplayName");
    }

    /**
     * Key {@code PKCE.DisplayName}: {@code Enable Proof Key for Code
     * Exchange (PKCE)}.
     * 
     * @return
     *     {@code Enable Proof Key for Code Exchange (PKCE)}
     */
    public static String PKCE_DisplayName() {
        return holder.format("PKCE.DisplayName");
    }

    /**
     * Key {@code PKCE.DisplayName}: {@code Enable Proof Key for Code
     * Exchange (PKCE)}.
     * 
     * @return
     *     {@code Enable Proof Key for Code Exchange (PKCE)}
     */
    public static Localizable _PKCE_DisplayName() {
        return new Localizable(holder, "PKCE.DisplayName");
    }

    /**
     * Key {@code DisableTokenVerification.DisplayName}: {@code Disable token
     * verification (JWKS)}.
     * 
     * @return
     *     {@code Disable token verification (JWKS)}
     */
    public static String DisableTokenVerification_DisplayName() {
        return holder.format("DisableTokenVerification.DisplayName");
    }

    /**
     * Key {@code DisableTokenVerification.DisplayName}: {@code Disable token
     * verification (JWKS)}.
     * 
     * @return
     *     {@code Disable token verification (JWKS)}
     */
    public static Localizable _DisableTokenVerification_DisplayName() {
        return new Localizable(holder, "DisableTokenVerification.DisplayName");
    }

    /**
     * Key {@code DisableNonce.DisplayName}: {@code Disable Nonce
     * verification}.
     * 
     * @return
     *     {@code Disable Nonce verification}
     */
    public static String DisableNonce_DisplayName() {
        return holder.format("DisableNonce.DisplayName");
    }

    /**
     * Key {@code DisableNonce.DisplayName}: {@code Disable Nonce
     * verification}.
     * 
     * @return
     *     {@code Disable Nonce verification}
     */
    public static Localizable _DisableNonce_DisplayName() {
        return new Localizable(holder, "DisableNonce.DisplayName");
    }

    /**
     * Key {@code LoginQueryParameters.DisplayName}: {@code Query Parameters
     * for Login Endpoint}.
     * 
     * @return
     *     {@code Query Parameters for Login Endpoint}
     */
    public static String LoginQueryParameters_DisplayName() {
        return holder.format("LoginQueryParameters.DisplayName");
    }

    /**
     * Key {@code LoginQueryParameters.DisplayName}: {@code Query Parameters
     * for Login Endpoint}.
     * 
     * @return
     *     {@code Query Parameters for Login Endpoint}
     */
    public static Localizable _LoginQueryParameters_DisplayName() {
        return new Localizable(holder, "LoginQueryParameters.DisplayName");
    }

}
