/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.metadata.OidcOpMetadataResolver;
import org.pac4j.oidc.metadata.StaticOidcOpMetadataResolver;
import org.pac4j.oidc.profile.creator.TokenValidator;

public class AnythingGoesTokenValidator
extends TokenValidator {
    public static final Logger LOGGER = Logger.getLogger(AnythingGoesTokenValidator.class.getName());

    public AnythingGoesTokenValidator() {
        this(AnythingGoesTokenValidator.createFakeOidcProviderMetadata());
    }

    public AnythingGoesTokenValidator(OIDCProviderMetadata metadata) {
        super(AnythingGoesTokenValidator.createFakeOidcConfiguration(metadata), metadata);
    }

    public IDTokenClaimsSet validate(JWT idToken, Nonce expectedNonce) {
        try {
            return new IDTokenClaimsSet(idToken.getJWTClaimsSet());
        }
        catch (ParseException | java.text.ParseException e) {
            LOGGER.log(Level.WARNING, "Token validation is disabled, but the token is corrupt and claims will not be represted.", e);
            try {
                return new IDTokenClaimsSet(new JWTClaimsSet.Builder().build());
            }
            catch (ParseException e1) {
                throw new TechnicalException("could not create and empty IDTokenClaimsSet");
            }
        }
    }

    private static OidcConfiguration createFakeOidcConfiguration(OIDCProviderMetadata metadata) {
        OidcConfiguration config = new OidcConfiguration();
        config.setClientId("ignored");
        config.setSecret("ignored");
        StaticOidcOpMetadataResolver opMetadataResolver = new StaticOidcOpMetadataResolver(config, metadata);
        config.setOpMetadataResolver((OidcOpMetadataResolver)opMetadataResolver);
        config.setPreferredJwsAlgorithm(JWSAlgorithm.HS256);
        config.setClientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        return config;
    }

    private static OIDCProviderMetadata createFakeOidcProviderMetadata() {
        try {
            OIDCProviderMetadata providerMetadata = new OIDCProviderMetadata(new Issuer("http://ignored"), List.of(SubjectType.PUBLIC), new URI("http://ignored.and.invalid./"));
            providerMetadata.setIDTokenJWSAlgs(List.of(JWSAlgorithm.HS256));
            return providerMetadata;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }
}

