/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.DomainSpecificationDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.jenkins.plugins.credentials.domains.DomainRequirementProvider;
import com.google.jenkins.plugins.credentials.oauth.OAuth2ScopeRequirement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class OAuth2ScopeSpecification<T extends OAuth2ScopeRequirement>
extends DomainSpecification {
    private final Collection<String> specifiedScopes;

    protected OAuth2ScopeSpecification(Collection<String> specifiedScopes) {
        this.specifiedScopes = (Collection)Preconditions.checkNotNull(specifiedScopes);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public final DomainSpecification.Result test(DomainRequirement requirement) {
        Class<T> providerRequirement = this.getDescriptor().getProviderRequirement();
        if (!providerRequirement.isInstance(requirement)) {
            return DomainSpecification.Result.UNKNOWN;
        }
        return this._test((OAuth2ScopeRequirement)requirement);
    }

    protected DomainSpecification.Result _test(T requirement) {
        for (String scope : ((OAuth2ScopeRequirement)((Object)requirement)).getScopes()) {
            if (this.specifiedScopes.contains(scope)) continue;
            return DomainSpecification.Result.NEGATIVE;
        }
        return DomainSpecification.Result.POSITIVE;
    }

    public Collection<String> getSpecifiedScopes() {
        return Collections.unmodifiableCollection(this.specifiedScopes);
    }

    public Descriptor<T> getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    public static abstract class Descriptor<T extends OAuth2ScopeRequirement>
    extends DomainSpecificationDescriptor {
        private final Class<T> providerRequirement;

        public Descriptor(Class<T> providerRequirement) {
            this.providerRequirement = (Class)Preconditions.checkNotNull(providerRequirement);
        }

        public Collection<String> getScopeItems() {
            List<OAuth2ScopeRequirement> requirements = DomainRequirementProvider.lookupRequirements(this.getProviderRequirement());
            HashSet result = Sets.newHashSet();
            for (OAuth2ScopeRequirement required : requirements) {
                Iterables.addAll((Collection)result, required.getScopes());
            }
            return result;
        }

        public Class<T> getProviderRequirement() {
            return this.providerRequirement;
        }
    }
}

