/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.plugins.credentials.domains;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.jenkins.plugins.credentials.domains.RequiresDomain;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;

public abstract class DomainRequirementProvider
implements ExtensionPoint {
    private static final Logger logger = Logger.getLogger(DomainRequirementProvider.class.getName());

    protected abstract <T extends DomainRequirement> List<T> provide(Class<T> var1);

    public static <T extends DomainRequirement> List<T> lookupRequirements(Class<T> type) {
        ExtensionList providers;
        try {
            providers = Jenkins.get().getExtensionList(DomainRequirementProvider.class);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return ImmutableList.of();
        }
        ArrayList result = Lists.newArrayList();
        for (DomainRequirementProvider provider : providers) {
            result.addAll(provider.provide(type));
        }
        return result;
    }

    @Nullable
    public static <T extends DomainRequirement> T of(Class<?> type, Class<T> requirementType) {
        RequiresDomain requiresDomain = type.getAnnotation(RequiresDomain.class);
        if (requiresDomain == null) {
            return null;
        }
        if (!requirementType.isAssignableFrom(requiresDomain.value())) {
            return null;
        }
        try {
            return (T)requiresDomain.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

