/*
 * Copyright 2013 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.jenkins.plugins.credentials.oauth;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;

/**
 * Credentials that have a username and an access token combination.
 *
 * @param <T> The type of {@link OAuth2ScopeRequirement}s with which this
 * credential may be applied.
 */
public interface StandardUsernameOAuth2Credentials<T
    extends OAuth2ScopeRequirement>
    extends StandardUsernameCredentials, OAuth2Credentials<T> {
}