/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.nunit.TestReportTransformer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jenkins.security.MasterToSlaveCallable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.xml.sax.SAXException;

public class NUnitArchiver
extends MasterToSlaveCallable<Boolean, IOException> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(NUnitArchiver.class.getName());
    private final String root;
    private final String junitDirectoryName;
    private final TaskListener listener;
    private final String testResultsPattern;
    private final TestReportTransformer unitReportTransformer;
    private final boolean failIfNoResults;
    private int fileCount;

    public NUnitArchiver(String root, String junitDirectoryName, TaskListener listener, String testResultsPattern, TestReportTransformer unitReportTransformer, boolean failIfNoResults) {
        this.root = root;
        this.junitDirectoryName = junitDirectoryName;
        this.listener = listener;
        this.testResultsPattern = testResultsPattern;
        this.unitReportTransformer = unitReportTransformer;
        this.failIfNoResults = failIfNoResults;
    }

    public Boolean call() throws IOException {
        boolean retValue = true;
        String[] nunitFiles = this.findNUnitReports(new File(this.root));
        if (nunitFiles.length > 0) {
            File junitOutputPath = new File(this.root, this.junitDirectoryName);
            if (junitOutputPath.mkdirs()) {
                LOGGER.log(Level.FINEST, "Created junit directories");
            }
            for (String nunitFileName : nunitFiles) {
                try (FileInputStream fileStream = new FileInputStream(new File(this.root, nunitFileName));){
                    this.unitReportTransformer.transform(fileStream, junitOutputPath);
                    ++this.fileCount;
                }
                catch (TransformerException te) {
                    throw new IOException("Could not transform the NUnit report. Please report this issue to the plugin author", te);
                }
                catch (SAXException se) {
                    throw new IOException("Could not transform the NUnit report. Please report this issue to the plugin author", se);
                }
                catch (ParserConfigurationException pce) {
                    throw new IOException("Could not initialize the XML parser. Please report this issue to the plugin author", pce);
                }
            }
        } else {
            retValue = false;
        }
        return retValue;
    }

    int getFileCount() {
        return this.fileCount;
    }

    private String[] findNUnitReports(File parentPath) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)this.testResultsPattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] nunitFiles = ds.getIncludedFiles();
        if (nunitFiles.length == 0) {
            if (this.failIfNoResults) {
                this.listener.fatalError("No NUnit test report files were found. Configuration error?");
            } else {
                this.listener.getLogger().println("No NUnit test report files were found.");
            }
        }
        return nunitFiles;
    }
}

