/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nunit;

import java.io.BufferedInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.input.BOMInputStream;

public class InvalidXmlStreamReader
extends FilterReader {
    private static final boolean[] validControls10 = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] validControls11 = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private final boolean[] validControls;
    private final char replacement;

    private InvalidXmlStreamReader(Source in, char replacement) {
        super(in.reader);
        this.validControls = "1.1".equals(in.version) ? validControls11 : validControls10;
        this.replacement = replacement;
    }

    public InvalidXmlStreamReader(InputStream in, char replacement) throws IOException {
        this(new Source(in), replacement);
    }

    private boolean isValid(int input) {
        if (input < 32) {
            return this.validControls[input];
        }
        return input <= 55295 || input >= 57344 && input <= 65533 || input >= 65536 && input <= 0x10FFFF;
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        if (read >= 0 && !this.isValid(read)) {
            return this.replacement;
        }
        return read;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = super.read(cbuf, off, len);
        if (read == -1) {
            return -1;
        }
        for (int readPos = off; readPos < off + read; ++readPos) {
            if (this.isValid(cbuf[readPos])) continue;
            cbuf[readPos] = this.replacement;
        }
        return read;
    }

    private static class Source {
        public final String version;
        public final Reader reader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Source(InputStream in) throws IOException {
            String encoding;
            BufferedInputStream is = new BufferedInputStream((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(in)).get());
            ((InputStream)is).mark(1024);
            try (XMLStreamReader xsr = XMLInputFactory.newFactory().createXMLStreamReader(is);){
                encoding = xsr.getCharacterEncodingScheme();
                this.version = xsr.getVersion();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
            ((InputStream)is).reset();
            this.reader = new InputStreamReader((InputStream)is, encoding == null ? "UTF-8" : encoding);
        }
    }
}

