/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jenkins.plugins.nodelabelparameter;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.labels.LabelExpression;
import hudson.model.queue.SubTask;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jvnet.jenkins.plugins.nodelabelparameter.LabelBadgeAction;
import org.jvnet.jenkins.plugins.nodelabelparameter.Messages;
import org.jvnet.jenkins.plugins.nodelabelparameter.MultipleNodeDescribingParameterDefinition;
import org.jvnet.jenkins.plugins.nodelabelparameter.NodeUtil;
import org.jvnet.jenkins.plugins.nodelabelparameter.node.AllNodeEligibility;
import org.jvnet.jenkins.plugins.nodelabelparameter.node.NodeEligibility;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class LabelParameterValue
extends ParameterValue {
    private static final Logger LOGGER = Logger.getLogger(LabelParameterValue.class.getName());
    private static final String DEFAULT_NAME = "NODELABEL";
    @Exported(visibility=3)
    private String label;
    protected List<String> nextLabels;

    public LabelParameterValue(String name) {
        super(LabelParameterValue.nameOrDefault(name));
    }

    @Deprecated
    public LabelParameterValue(String name, String label) {
        this(name, label, false, new AllNodeEligibility());
    }

    public LabelParameterValue(String name, List<String> labels, NodeEligibility nodeEligibility) {
        super(name);
        this.setNextLabels(labels, nodeEligibility);
    }

    @DataBoundConstructor
    public LabelParameterValue(String name, String label, boolean allNodesMatchingLabel, NodeEligibility nodeEligibility) {
        super(LabelParameterValue.nameOrDefault(name));
        if (label != null) {
            this.label = label.trim();
        }
        this.computeNextLabels(allNodesMatchingLabel, nodeEligibility);
    }

    void computeNextLabels(boolean allNodesMatchingLabel, NodeEligibility nodeEligibility) {
        if (allNodesMatchingLabel && this.label != null) {
            List<String> labels = this.getNodeNamesForLabelExpression(this.label);
            if (labels.isEmpty()) {
                labels.add(this.label);
            }
            this.setNextLabels(labels, nodeEligibility);
        }
    }

    private void setNextLabels(List<String> labels, NodeEligibility nodeEligibility) {
        if (labels != null && !labels.isEmpty()) {
            ArrayList<String> tmpLabels = new ArrayList<String>(labels);
            this.nextLabels = new ArrayList<String>();
            for (String nodeName : tmpLabels) {
                if (nodeEligibility.isEligible(nodeName)) {
                    if (this.getLabel() == null && NodeUtil.isNodeOnline(nodeName)) {
                        this.setLabel(nodeName.trim());
                        continue;
                    }
                    this.nextLabels.add(nodeName);
                    continue;
                }
                LOGGER.fine(Messages.NodeListBuildParameterFactory_skippOfflineNode(nodeName));
            }
            if (this.getLabel() == null && !this.nextLabels.isEmpty()) {
                this.setLabel(this.nextLabels.remove(0).trim());
            }
        }
        if (StringUtils.isBlank((String)this.getLabel())) {
            this.setLabel(Messages.LabelParameterValue_triggerWithoutValidOnlineNode(StringUtils.join(labels, (char)',')));
        }
    }

    private List<String> getNodeNamesForLabelExpression(String labelExp) {
        ArrayList<String> nodeNames = new ArrayList<String>();
        try {
            Label label = LabelExpression.parseExpression((String)labelExp);
            for (Node node : label.getNodes()) {
                nodeNames.add(node.getSelfLabel().getName());
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "failed to parse label [" + labelExp + "]", e);
        }
        return nodeNames;
    }

    public LabelParameterValue(String name, String description, String label) {
        super(LabelParameterValue.nameOrDefault(name), description);
        if (label != null) {
            this.label = label.trim();
        }
    }

    private static String nameOrDefault(String name) {
        return Util.fixEmptyAndTrim((String)Util.fixEmpty((String)name)) == null ? DEFAULT_NAME : name;
    }

    public List<String> getNextLabels() {
        return Collections.unmodifiableList(this.nextLabels == null ? new ArrayList() : this.nextLabels);
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        env.put(this.name, this.label);
    }

    public Label getAssignedLabel(SubTask task) {
        return Label.get((String)this.label);
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                return LabelParameterValue.this.name.equals(name) ? LabelParameterValue.this.label : null;
            }
        };
    }

    public String toString() {
        return "[LabelParameterValue: " + this.name + "=" + this.label + "]";
    }

    @Exported(name="value")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label != null) {
            this.label = label.trim();
        }
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        this.addBadgeToBuild(build);
        ParametersDefinitionProperty property = (ParametersDefinitionProperty)build.getProject().getProperty(ParametersDefinitionProperty.class);
        if (property != null) {
            List parameterDefinitions = property.getParameterDefinitions();
            for (ParameterDefinition paramDef : parameterDefinitions) {
                if (!(paramDef instanceof MultipleNodeDescribingParameterDefinition)) continue;
                MultipleNodeDescribingParameterDefinition definition = (MultipleNodeDescribingParameterDefinition)paramDef;
                return definition.createBuildWrapper();
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelParameterValue that = (LabelParameterValue)((Object)o);
        return Objects.equals(this.label, that.label);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        return result;
    }

    protected void addBadgeToBuild(AbstractBuild<?, ?> build) {
        Computer c = Computer.currentComputer();
        String controllerLabel = Jenkins.get().getSelfLabel().getName();
        if (c != null) {
            String cName = StringUtils.isBlank((String)c.getName()) ? controllerLabel : c.getName();
            build.addAction((Action)new LabelBadgeAction(this.getLabel(), Messages.LabelBadgeAction_label_tooltip_node(this.getLabel(), cName)));
        } else {
            build.addAction((Action)new LabelBadgeAction(this.getLabel(), Messages.LabelBadgeAction_label_tooltip(this.getLabel())));
        }
    }
}

