/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import java.text.MessageFormat;
import java.util.StringTokenizer;
import jenkins.plugins.nodejs.tools.NodeJSVersion;

public class NodeJSVersionRange {
    public static final char LEFT_OPEN = '(';
    public static final char LEFT_CLOSED = '[';
    public static final char RIGHT_OPEN = ')';
    public static final char RIGHT_CLOSED = ']';
    private static final String MSG_INVALID_FORMAT = "invalid range \"{0}\": invalid format";
    private static final String LEFT_OPEN_DELIMITER = "(";
    private static final String LEFT_CLOSED_DELIMITER = "[";
    private static final String LEFT_DELIMITERS = "[(";
    private static final String RIGHT_OPEN_DELIMITER = ")";
    private static final String RIGHT_CLOSED_DELIMITER = "]";
    private static final String RIGHT_DELIMITERS = ")]";
    private static final String ENDPOINT_DELIMITER = ",";
    private final boolean leftClosed;
    private final NodeJSVersion left;
    private final NodeJSVersion right;
    private final boolean rightClosed;
    private final boolean empty;
    private transient String versionRangeString;
    private transient int hash;

    public NodeJSVersionRange(String range) {
        NodeJSVersion endpointRight;
        boolean closedRight;
        NodeJSVersion endpointLeft;
        boolean closedLeft;
        try {
            StringTokenizer st = new StringTokenizer(range, LEFT_DELIMITERS, true);
            String token = st.nextToken().trim();
            if (token.length() == 0) {
                token = st.nextToken();
            }
            if (!(closedLeft = LEFT_CLOSED_DELIMITER.equals(token)) && !LEFT_OPEN_DELIMITER.equals(token)) {
                if (st.hasMoreTokens()) {
                    throw new IllegalArgumentException(MessageFormat.format(MSG_INVALID_FORMAT, range));
                }
                this.leftClosed = true;
                this.rightClosed = false;
                this.left = NodeJSVersion.parseVersion(token);
                this.right = null;
                this.empty = false;
                return;
            }
            String version = st.nextToken(ENDPOINT_DELIMITER);
            endpointLeft = NodeJSVersion.parseVersion(version);
            token = st.nextToken();
            version = st.nextToken(RIGHT_DELIMITERS);
            token = st.nextToken();
            closedRight = RIGHT_CLOSED_DELIMITER.equals(token);
            if (!closedRight && !RIGHT_OPEN_DELIMITER.equals(token)) {
                throw new IllegalArgumentException(MessageFormat.format(MSG_INVALID_FORMAT, range));
            }
            endpointRight = NodeJSVersion.parseVersion(version);
            if (st.hasMoreTokens() && (token = st.nextToken("").trim()).length() != 0) {
                throw new IllegalArgumentException(MessageFormat.format(MSG_INVALID_FORMAT, range));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid range \"" + range + "\": " + e.getMessage(), e);
        }
        this.leftClosed = closedLeft;
        this.rightClosed = closedRight;
        this.left = endpointLeft;
        this.right = endpointRight;
        this.empty = this.isEmpty0();
    }

    public NodeJSVersion getLeft() {
        return this.left;
    }

    public NodeJSVersion getRight() {
        return this.right;
    }

    public char getLeftType() {
        return this.leftClosed ? (char)'[' : '(';
    }

    public char getRightType() {
        return this.rightClosed ? (char)']' : ')';
    }

    public boolean includes(NodeJSVersion version) {
        if (this.empty) {
            return false;
        }
        if (this.left.compareTo(version) >= (this.leftClosed ? 1 : 0)) {
            return false;
        }
        if (this.right == null) {
            return true;
        }
        return this.right.compareTo(version) >= (this.rightClosed ? 0 : 1);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private boolean isEmpty0() {
        if (this.right == null) {
            return false;
        }
        int comparison = this.left.compareTo(this.right);
        if (comparison == 0) {
            return !this.leftClosed || !this.rightClosed;
        }
        return comparison > 0;
    }

    public String toString() {
        if (this.versionRangeString != null) {
            return this.versionRangeString;
        }
        String leftVersion = this.left.toString();
        if (this.right == null) {
            StringBuilder result = new StringBuilder(leftVersion.length() + 1);
            result.append(this.left.toString0());
            this.versionRangeString = result.toString();
            return this.versionRangeString;
        }
        String rightVerion = this.right.toString();
        StringBuilder result = new StringBuilder(leftVersion.length() + rightVerion.length() + 5);
        result.append(this.leftClosed ? (char)'[' : '(');
        result.append(this.left.toString0());
        result.append(ENDPOINT_DELIMITER);
        result.append(this.right.toString0());
        result.append(this.rightClosed ? (char)']' : ')');
        this.versionRangeString = result.toString();
        return this.versionRangeString;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        if (this.empty) {
            this.hash = 31;
            return 31;
        }
        int h = 31 + (this.leftClosed ? 7 : 5);
        h = 31 * h + this.left.hashCode();
        if (this.right != null) {
            h = 31 * h + this.right.hashCode();
            h = 31 * h + (this.rightClosed ? 7 : 5);
        }
        this.hash = h;
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NodeJSVersionRange)) {
            return false;
        }
        NodeJSVersionRange other = (NodeJSVersionRange)object;
        if (this.empty && other.empty) {
            return true;
        }
        if (this.right == null) {
            return this.leftClosed == other.leftClosed && other.right == null && this.left.equals(other.left);
        }
        return this.leftClosed == other.leftClosed && this.rightClosed == other.rightClosed && this.left.equals(other.left) && this.right.equals(other.right);
    }
}

