/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.DetectionFailedException;
import jenkins.plugins.nodejs.tools.NodeJSInstaller;
import jenkins.plugins.nodejs.tools.Platform;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class NodeJSInstallation
extends ToolInstallation
implements EnvironmentSpecific<NodeJSInstallation>,
NodeSpecific<NodeJSInstallation> {
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="calculate at runtime, its value depends on the OS where it run")
    private transient Platform platform;

    @DataBoundConstructor
    public NodeJSInstallation(@NonNull String name, @Nullable String home, List<? extends ToolProperty<?>> properties) {
        this(name, home, properties, null);
    }

    protected NodeJSInstallation(@NonNull String name, @Nullable String home, List<? extends ToolProperty<?>> properties, Platform platform) {
        super(Util.fixEmptyAndTrim((String)name), Util.fixEmptyAndTrim((String)home), properties);
        this.platform = platform;
    }

    public NodeJSInstallation forEnvironment(EnvVars environment) {
        return new NodeJSInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList(), this.platform);
    }

    public NodeJSInstallation forNode(@NonNull Node node, TaskListener log) throws IOException, InterruptedException {
        return new NodeJSInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList(), Platform.of(node));
    }

    public void buildEnvVars(EnvVars env) {
        String home = this.getHome();
        if (home == null) {
            return;
        }
        env.put("NODEJS_HOME", home);
        env.put("NODE_HOME", home);
        env.put("PATH+NODEJS", this.getBin());
    }

    public String getExecutable(Launcher launcher) throws InterruptedException, IOException {
        VirtualChannel channel = launcher.getChannel();
        if (channel == null) {
            throw new IOException("Unable to get a channel for the launcher");
        }
        return (String)channel.call((Callable)new DetectPlatformCallable(this.getHome()));
    }

    private String getBin() {
        Platform currentPlatform = null;
        try {
            currentPlatform = this.getPlatform();
        }
        catch (DetectionFailedException e) {
            throw new RuntimeException(e);
        }
        return NodeJSInstallation.getBin(currentPlatform, this.getHome());
    }

    private static String getBin(Platform currentPlatform, String home) {
        Object bin = home;
        if (!"".equals(currentPlatform.binFolder)) {
            switch (currentPlatform) {
                case WINDOWS: {
                    bin = (String)bin + "\\" + currentPlatform.binFolder;
                    break;
                }
                default: {
                    bin = (String)bin + "/" + currentPlatform.binFolder;
                }
            }
        }
        return bin;
    }

    private Platform getPlatform() throws DetectionFailedException {
        Platform currentPlatform = this.platform;
        if (currentPlatform == null) {
            Computer computer = Computer.currentComputer();
            if (computer != null) {
                Node node = computer.getNode();
                if (node == null) {
                    throw new DetectionFailedException(Messages.NodeJSBuilders_nodeOffline());
                }
                currentPlatform = Platform.of(node);
            } else {
                currentPlatform = Platform.current();
            }
            this.platform = currentPlatform;
        }
        return currentPlatform;
    }

    private static final class DetectPlatformCallable
    extends MasterToSlaveCallable<String, IOException> {
        private final String home;

        DetectPlatformCallable(String home) {
            this.home = home;
        }

        public String call() throws IOException {
            Platform currentPlatform = Platform.current();
            File exe = new File(NodeJSInstallation.getBin(currentPlatform, this.home), currentPlatform.nodeFileName);
            if (exe.exists()) {
                return exe.getPath();
            }
            return null;
        }
    }

    @Symbol(value={"nodejs"})
    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<NodeJSInstallation> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.NodeJSInstallation_displayName();
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new NodeJSInstaller(null, null, 72L));
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            boolean result = super.configure(req, json);
            this.save();
            return result;
        }
    }
}

