/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.NodeJSUtils;
import jenkins.plugins.nodejs.configfiles.NPMConfig;
import jenkins.plugins.nodejs.configfiles.VerifyConfigProviderException;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;

final class NodeJSDescriptorUtils {
    private NodeJSDescriptorUtils() {
    }

    @NonNull
    public static ListBoxModel getConfigs(@Nullable ItemGroup<?> context) {
        ListBoxModel items = new ListBoxModel();
        items.add(Messages.NPMConfig_default(), "");
        for (Config config : ConfigFiles.getConfigsInContext(context, NPMConfig.NPMConfigProvider.class)) {
            items.add(config.name, config.id);
        }
        return items;
    }

    public static FormValidation checkConfig(@Nullable ItemGroup<?> context, @CheckForNull String configId) {
        Config config;
        if (configId != null && (config = ConfigFiles.getByIdOrNull(context, (String)configId)) != null) {
            try {
                ((NPMConfig)config).doVerify();
            }
            catch (VerifyConfigProviderException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
        return FormValidation.ok();
    }

    public static ListBoxModel getNodeJSInstallations(@Nullable Item item, boolean allowDefault) {
        ListBoxModel items = new ListBoxModel();
        if (item == null || !item.hasPermission(Item.CONFIGURE)) {
            return items;
        }
        if (allowDefault) {
            items.add(Messages.NodeJSInstallation_default(), "");
        }
        for (NodeJSInstallation tool : NodeJSUtils.getInstallations()) {
            items.add(tool.getName(), tool.getName());
        }
        return items;
    }
}

