/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.nodejs.tools;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeSpecific;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolInstallation;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.plugins.nodejs.Messages;
import jenkins.plugins.nodejs.tools.CPU;
import jenkins.plugins.nodejs.tools.DetectionFailedException;
import jenkins.plugins.nodejs.tools.InstallerPathResolver;
import jenkins.plugins.nodejs.tools.NodeJSInstallation;
import jenkins.plugins.nodejs.tools.Platform;
import jenkins.plugins.nodejs.tools.ToolsUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class NodeJSInstaller
extends DownloadFromUrlInstaller {
    private static boolean DISABLE_CACHE = Boolean.getBoolean(NodeJSInstaller.class.getName() + ".cache.disable");
    public static final String NPM_PACKAGES_RECORD_FILENAME = ".npmPackages";
    public static final int DEFAULT_NPM_PACKAGES_REFRESH_HOURS = 72;
    private final String npmPackages;
    private final Long npmPackagesRefreshHours;
    private boolean force32Bit;

    @DataBoundConstructor
    public NodeJSInstaller(String id, String npmPackages, long npmPackagesRefreshHours) {
        super(id);
        this.npmPackages = Util.fixEmptyAndTrim((String)npmPackages);
        this.npmPackagesRefreshHours = npmPackagesRefreshHours;
    }

    public NodeJSInstaller(String id, String npmPackages, long npmPackagesRefreshHours, boolean force32bit) {
        this(id, npmPackages, npmPackagesRefreshHours);
        this.force32Bit = force32bit;
    }

    public DownloadFromUrlInstaller.Installable getInstallable() throws IOException {
        DownloadFromUrlInstaller.Installable installable = super.getInstallable();
        return installable != null ? new NodeJSInstallable(installable) : installable;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath expected = this.preferredLocation(tool, node);
        DownloadFromUrlInstaller.Installable installable = this.getInstallable();
        if (installable == null) {
            log.getLogger().println("Invalid tool ID " + this.id);
            return expected;
        }
        if (installable instanceof NodeSpecific) {
            installable = (DownloadFromUrlInstaller.Installable)((NodeSpecific)installable).forNode(node, log);
        }
        if (!this.isUpToDate(expected, installable)) {
            File cache = this.getLocalCacheFile(installable, node);
            boolean skipInstall = false;
            if (!DISABLE_CACHE && cache.exists()) {
                log.getLogger().println(Messages.NodeJSInstaller_installFromCache(cache, expected, node.getDisplayName()));
                try {
                    this.restoreCache(expected, cache, log);
                    skipInstall = true;
                }
                catch (IOException e) {
                    log.error("Use of caches failed: " + e.getMessage());
                }
            }
            if (!skipInstall) {
                String message = installable.url + " to " + String.valueOf(expected) + " on " + node.getDisplayName();
                boolean isMSI = installable.url.toLowerCase(Locale.ENGLISH).endsWith("msi");
                URL installableURL = new URL(installable.url);
                if (isMSI && this.installIfNecessaryMSI(expected, installableURL, log, "Installing " + message) || expected.installIfNecessaryFrom(installableURL, log, "Unpacking " + message)) {
                    expected.child(".timestamp").delete();
                    FilePath base = this.findPullUpDirectory(expected);
                    if (base != null && base != expected) {
                        base.moveAllChildrenTo(expected);
                    }
                    expected.child(".installedFrom").write(installable.url, "UTF-8");
                    if (!DISABLE_CACHE) {
                        this.buildCache(expected, cache);
                    }
                }
            }
        }
        this.refreshGlobalPackages(node, log, expected);
        return expected;
    }

    private void restoreCache(FilePath expected, File cache, TaskListener log) throws IOException, InterruptedException {
        try (InputStream in = cache.toURI().toURL().openStream();){
            CountingInputStream cis = new CountingInputStream(in);
            try {
                Objects.requireNonNull(expected).untarFrom((InputStream)cis, FilePath.TarCompression.GZIP);
            }
            catch (IOException e) {
                throw new IOException(Messages.NodeJSInstaller_failedToUnpack(cache.toURI().toURL(), cis.getByteCount()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCache(FilePath expected, File cache) throws IOException, InterruptedException {
        Path tmp = new File(cache.getPath() + ".tmp").toPath();
        try {
            Path tmpParent = tmp.getParent();
            if (tmpParent != null) {
                Files.createDirectories(tmpParent, new FileAttribute[0]);
            }
            try (GZIPOutputStream out = new GZIPOutputStream(Files.newOutputStream(tmp, new OpenOption[0]));){
                expected.tar((OutputStream)out, "**");
            }
            Files.move(tmp, cache.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmp);
        }
    }

    protected void refreshGlobalPackages(Node node, TaskListener log, FilePath expected) throws IOException, InterruptedException {
        boolean skipNpmPackageInstallation;
        String globalPackages = this.getNpmPackages();
        if (StringUtils.isNotBlank((CharSequence)globalPackages) && !(skipNpmPackageInstallation = NodeJSInstaller.areNpmPackagesUpToDate(expected, globalPackages, this.getNpmPackagesRefreshHours()))) {
            expected.child(NPM_PACKAGES_RECORD_FILENAME).delete();
            Platform platform = ToolsUtils.getPlatform(node);
            ArgumentListBuilder npmScriptArgs = new ArgumentListBuilder();
            if (platform == Platform.WINDOWS) {
                npmScriptArgs.add("cmd");
                npmScriptArgs.add("/c");
            }
            FilePath binFolder = expected.child(platform.binFolder);
            FilePath npmExe = binFolder.child(platform.npmFileName);
            npmScriptArgs.add((Object)npmExe);
            npmScriptArgs.add("install");
            npmScriptArgs.add("-g");
            for (String packageName : globalPackages.split("\\s")) {
                npmScriptArgs.add(packageName);
            }
            EnvVars env = new EnvVars();
            env.put("PATH+NODEJS", binFolder.getRemote());
            try {
                this.buildProxyEnvVars(env, log);
            }
            catch (URISyntaxException e) {
                log.error("Wrong proxy URL: " + e.getMessage());
            }
            Launcher launcher = node.createLauncher(log);
            int returnCode = launcher.launch().envs((Map)env).cmds(npmScriptArgs).stdout(log).join();
            if (returnCode == 0) {
                expected.child(NPM_PACKAGES_RECORD_FILENAME).write(globalPackages, "UTF-8");
                expected.child(NPM_PACKAGES_RECORD_FILENAME).act((FilePath.FileCallable)new ChmodRecAPlusX());
            }
        }
    }

    private void buildProxyEnvVars(EnvVars env, TaskListener log) throws IOException, URISyntaxException {
        ProxyConfiguration proxycfg = Jenkins.get().getProxy();
        if (proxycfg == null) {
            return;
        }
        Object userInfo = proxycfg.getUserName();
        if (userInfo != null && proxycfg.getSecretPassword() != null) {
            userInfo = (String)userInfo + ":" + Secret.toString((Secret)proxycfg.getSecretPassword());
        }
        String proxyURL = new URI("http", (String)userInfo, proxycfg.name, proxycfg.port, null, null, null).toString();
        env.put("HTTP_PROXY", proxyURL);
        env.put("HTTPS_PROXY", proxyURL);
        String noProxyHosts = proxycfg.getNoProxyHost();
        if (noProxyHosts != null) {
            if (noProxyHosts.contains("*")) {
                log.getLogger().println("INFO: npm doesn't support wild card in no_proxy configuration");
            }
            env.put("NO_PROXY", noProxyHosts.replaceAll("(\r?\n)+", ","));
        }
    }

    public static boolean areNpmPackagesUpToDate(FilePath expected, String npmPackages, long npmPackagesRefreshHours) throws IOException, InterruptedException {
        FilePath marker = expected.child(NPM_PACKAGES_RECORD_FILENAME);
        return marker.exists() && marker.readToString().equals(npmPackages) && System.currentTimeMillis() < marker.lastModified() + TimeUnit.HOURS.toMillis(npmPackagesRefreshHours);
    }

    private boolean installIfNecessaryMSI(FilePath expected, URL archive, TaskListener listener, String message) throws IOException, InterruptedException {
        try {
            URLConnection con;
            try {
                con = ProxyConfiguration.open((URL)archive);
                con.connect();
            }
            catch (IOException x) {
                if (expected.exists()) {
                    if (listener != null) {
                        listener.getLogger().println("Skipping installation of " + String.valueOf(archive) + " to " + expected.getRemote() + ": " + String.valueOf(x));
                    }
                    return false;
                }
                throw x;
            }
            long sourceTimestamp = con.getLastModified();
            FilePath timestamp = expected.child(".timestamp");
            if (expected.exists()) {
                if (timestamp.exists() && sourceTimestamp == timestamp.lastModified()) {
                    return false;
                }
                expected.deleteContents();
            } else {
                expected.mkdirs();
            }
            if (listener != null) {
                listener.getLogger().println(message);
            }
            FilePath temp = expected.createTempDir("_temp", "");
            FilePath msi = temp.child("nodejs.msi");
            msi.copyFrom(archive);
            try {
                Launcher launch = temp.createLauncher(listener);
                Launcher.ProcStarter starter = launch.launch().cmds(new File("cmd"), new String[]{"/c", "for %A in (.) do msiexec TARGETDIR=\"%~sA\" /a " + temp.getName() + "\\nodejs.msi /qn /L* " + temp.getName() + "\\log.txt"});
                starter = starter.pwd(expected);
                int exitCode = starter.join();
                if (exitCode != 0) {
                    throw new IOException("msiexec failed. exit code: " + exitCode + " Please see the log file " + temp.child("log.txt").getRemote() + " for more informations.", null);
                }
                if (listener != null) {
                    listener.getLogger().println("msi install complete");
                }
                temp.deleteRecursive();
                FilePath duplicatedMSI = expected.child("nodejs.msi");
                if (duplicatedMSI.exists()) {
                    duplicatedMSI.delete();
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to install " + String.valueOf(archive), e);
            }
            timestamp.touch(sourceTimestamp);
            return true;
        }
        catch (IOException e) {
            throw new IOException("Failed to install " + String.valueOf(archive) + " to " + expected.getRemote(), e);
        }
    }

    public String getNpmPackages() {
        return this.npmPackages;
    }

    public Long getNpmPackagesRefreshHours() {
        return this.npmPackagesRefreshHours;
    }

    public boolean isForce32Bit() {
        return this.force32Bit;
    }

    @DataBoundSetter
    public void setForce32Bit(boolean force32Bit) {
        this.force32Bit = force32Bit;
    }

    protected File getLocalCacheFile(DownloadFromUrlInstaller.Installable installable, Node node) throws DetectionFailedException {
        Platform platform = ToolsUtils.getPlatform(node);
        CPU cpu = ToolsUtils.getCPU(node);
        return new File(Jenkins.get().getRootDir(), "caches/nodejs/" + String.valueOf((Object)platform) + "/" + String.valueOf((Object)cpu) + "/" + this.id + ".tar.gz");
    }

    protected final class NodeJSInstallable
    extends DownloadFromUrlInstaller.NodeSpecificInstallable {
        public NodeJSInstallable(DownloadFromUrlInstaller.Installable inst) {
            super((DownloadFromUrlInstaller)NodeJSInstaller.this, inst);
        }

        public DownloadFromUrlInstaller.NodeSpecificInstallable forNode(Node node, TaskListener log) throws IOException, InterruptedException {
            InstallerPathResolver installerPathResolver = InstallerPathResolver.Factory.findResolverFor(this.id);
            String relativeDownloadPath = installerPathResolver.resolvePathFor(this.id, ToolsUtils.getPlatform(node), ToolsUtils.getCPU(node));
            this.url = this.url + relativeDownloadPath;
            return this;
        }
    }

    static class ChmodRecAPlusX
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        ChmodRecAPlusX() {
        }

        public Void invoke(File d, VirtualChannel channel) throws IOException {
            if (!Functions.isWindows()) {
                this.process(d);
            }
            return null;
        }

        private void process(File f) {
            if (f.isFile()) {
                f.setExecutable(true, false);
            } else {
                File[] kids = f.listFiles();
                if (kids != null) {
                    for (File kid : kids) {
                        this.process(kid);
                    }
                }
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends DownloadFromUrlInstaller.DescriptorImpl<NodeJSInstaller> {
        public String getDisplayName() {
            return Messages.NodeJSInstaller_DescriptorImpl_displayName();
        }

        @NonNull
        public List<? extends DownloadFromUrlInstaller.Installable> getInstallables() throws IOException {
            return ToolsUtils.getInstallable();
        }

        public String getId() {
            return "hudson.plugins.nodejs.tools.NodeJSInstaller";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == NodeJSInstallation.class;
        }
    }
}

