/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.View;
import hudson.plugins.nextexecutions.Messages;
import hudson.plugins.nextexecutions.NextBuilds;
import hudson.plugins.nextexecutions.NextExecutionsWidget;
import hudson.plugins.nextexecutions.utils.ParameterizedNextExecutionsUtils;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.widgets.WidgetFactory;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTrigger;

public class ParameterizedNextExecutionsWidget
extends NextExecutionsWidget {
    public ParameterizedNextExecutionsWidget(@NonNull String ownerUrl) {
        super(ownerUrl, ParameterizedTimerTrigger.class);
    }

    @Override
    public String getWidgetName() {
        return Messages.ParameterizedExec_WidgetName();
    }

    @Override
    public boolean showWidget() {
        NextBuilds.DescriptorImpl d;
        Jenkins j = Jenkins.getInstanceOrNull();
        NextBuilds.DescriptorImpl descriptorImpl = d = j != null ? (NextBuilds.DescriptorImpl)j.getDescriptorOrDie(NextBuilds.class) : null;
        if (d == null) {
            return false;
        }
        return d.getShowParameterizedWidget();
    }

    @Override
    public String getWidgetId() {
        return super.getWidgetId() + "-parameterized";
    }

    @Override
    protected NextBuilds getNextBuild(ParameterizedJobMixIn.ParameterizedJob project) {
        return ParameterizedNextExecutionsUtils.getNextBuild(project, this.triggerClass);
    }

    @Symbol(value={"parameterizedNextExecutionsWidget"})
    @Extension(optional=true, ordinal=-10.0)
    public static final class FactoryImpl
    extends WidgetFactory<View, ParameterizedNextExecutionsWidget> {
        public Class<View> type() {
            return View.class;
        }

        public Class<ParameterizedNextExecutionsWidget> widgetType() {
            return ParameterizedNextExecutionsWidget.class;
        }

        @NonNull
        public Collection<ParameterizedNextExecutionsWidget> createFor(@NonNull View target) {
            if (Jenkins.get().getPlugin("parameterized-scheduler") != null) {
                return List.of(new ParameterizedNextExecutionsWidget(target.getUrl()));
            }
            return List.of();
        }
    }
}

