/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions.columns;

import hudson.Extension;
import hudson.model.Job;
import hudson.plugins.nextexecutions.NextBuilds;
import hudson.plugins.nextexecutions.columns.Messages;
import hudson.plugins.nextexecutions.utils.NextExecutionsUtils;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.kohsuke.stapler.DataBoundConstructor;

public class NextExecutionColumn
extends ListViewColumn {
    protected Class<? extends Trigger> triggerClass = TimerTrigger.class;

    @DataBoundConstructor
    public NextExecutionColumn() {
    }

    public String getColumnId() {
        return "column-next-launch";
    }

    public String getNextExecution(Job job) {
        ParameterizedJobMixIn.ParameterizedJob project;
        NextBuilds b;
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob && (b = this.getNextBuild(project = (ParameterizedJobMixIn.ParameterizedJob)job)) != null) {
            return b.getDate();
        }
        return "";
    }

    protected NextBuilds getNextBuild(ParameterizedJobMixIn.ParameterizedJob project) {
        return NextExecutionsUtils.getNextBuild(project, this.triggerClass);
    }

    public boolean getShowParameterizedWidget() {
        NextBuilds.DescriptorImpl d;
        Jenkins j = Jenkins.getInstanceOrNull();
        NextBuilds.DescriptorImpl descriptorImpl = d = j != null ? (NextBuilds.DescriptorImpl)j.getDescriptorOrDie(NextBuilds.class) : null;
        if (d == null) {
            return false;
        }
        return d.getShowParameterizedWidget() && j.getPlugin("parameterized-scheduler") != null;
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.NextExecutions_ColumnName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

