/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions.utils;

import hudson.plugins.nextexecutions.NextBuilds;
import hudson.scheduler.CronTabList;
import hudson.triggers.Trigger;
import io.jenkins.plugins.extended_timer_trigger.ExtendedTimerTrigger;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import jenkins.model.ParameterizedJobMixIn;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

public class ExtendedNextExecutionsUtils {
    private ExtendedNextExecutionsUtils() {
    }

    @SuppressRestrictedWarnings(value={CronTabList.class})
    public static NextBuilds getNextBuild(ParameterizedJobMixIn.ParameterizedJob project, Class<? extends Trigger> triggerClass) {
        GregorianCalendar cal = null;
        Object timezone = null;
        if (project.isDisabled()) {
            return null;
        }
        Map triggers = project.getTriggers();
        Iterator iterator = triggers.entrySet().iterator();
        while (iterator.hasNext()) {
            ZonedDateTime next;
            Trigger trigger = (Trigger)iterator.next().getValue();
            if (!(trigger instanceof ExtendedTimerTrigger)) continue;
            ExtendedTimerTrigger ett = (ExtendedTimerTrigger)trigger;
            if (!triggerClass.equals(ExtendedTimerTrigger.class) || (next = ett.getExtendedCronTabList().next()) == null) continue;
            GregorianCalendar triggerCal = GregorianCalendar.from(next);
            if (cal != null && !triggerCal.before(cal)) continue;
            cal = triggerCal;
        }
        if (cal != null) {
            return new NextBuilds(project, cal);
        }
        return null;
    }
}

