package hudson.plugins.nextexecutions.columns;

import hudson.model.Job;
import hudson.plugins.nextexecutions.NextBuilds;
import hudson.triggers.Trigger;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;

@SuppressWarnings("rawtypes")
public abstract class NextExecutionColumnBase extends ListViewColumn {

    protected Class<? extends Trigger> triggerClass;

    protected NextExecutionColumnBase() {}

    public abstract String getColumnId();

    public String getNextExecution(Job job) {
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob project) {
            NextBuilds b = getNextBuild(project);
            if (b != null) {
                return b.getDate();
            }
        }
        return "";
    }

    protected abstract NextBuilds getNextBuild(ParameterizedJobMixIn.ParameterizedJob project);

    public boolean getShowParameterizedWidget() {
        Jenkins j = Jenkins.getInstanceOrNull();
        NextBuilds.DescriptorImpl d =
                j != null ? (NextBuilds.DescriptorImpl) (j.getDescriptorOrDie(NextBuilds.class)) : null;
        if (d == null) {
            return false;
        }
        return d.getShowParameterizedWidget() && j.getPlugin("parameterized-scheduler") != null;
    }

    public abstract static class DescriptorImpl extends ListViewColumnDescriptor {
        @Override
        public boolean shownByDefault() {
            return false;
        }
    }
}
