/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nextexecutions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.plugins.nextexecutions.Messages;
import hudson.util.FormValidation;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class NextBuilds
implements Comparable,
Describable<NextBuilds> {
    private ParameterizedJobMixIn.ParameterizedJob project;
    private String name;
    private Calendar date;

    public NextBuilds(ParameterizedJobMixIn.ParameterizedJob project, Calendar date) {
        this.project = project;
        this.name = Util.escape((String)project.getFullDisplayName());
        this.date = date;
    }

    private String formatDate(ZonedDateTime d) {
        String dateFormat = this.getDescriptor().getDateFormat();
        if (dateFormat == null) {
            dateFormat = this.getDescriptor().getDefault();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        return formatter.format(d);
    }

    @Exported
    public String getDate() {
        return this.formatDate(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.date.getTimeInMillis()), this.date.getTimeZone().toZoneId()));
    }

    public String getTimeToGo() {
        ZoneId zone = this.date.getTimeZone().toZoneId();
        ZonedDateTime now = ZonedDateTime.now(zone);
        ZonedDateTime zonedDate = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.date.getTimeInMillis()), zone);
        Duration duration = Duration.between(now, zonedDate);
        long days = duration.toDays();
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m");
        }
        return Messages.timeToGo(sb.toString());
    }

    @Exported
    public String getName() {
        return this.name;
    }

    @Exported
    public String getUrl() {
        Jenkins j = Jenkins.getInstanceOrNull();
        return j != null ? j.getRootUrl() + this.project.getUrl() : null;
    }

    public String getshortName() {
        return this.name.length() > 22 ? this.name.substring(0, 19) + "..." : this.name;
    }

    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public int compareTo(Object o) {
        if (o instanceof NextBuilds) {
            NextBuilds toCompare = (NextBuilds)o;
            return this.date.compareTo(toCompare.date);
        }
        return 0;
    }

    public DescriptorImpl getDescriptor() {
        Jenkins j = Jenkins.getInstanceOrNull();
        return j != null ? (DescriptorImpl)j.getDescriptorOrDie(this.getClass()) : null;
    }

    @Extension
    @Symbol(value={"nextBuilds"})
    public static class DescriptorImpl
    extends Descriptor<NextBuilds> {
        private String dateFormat;
        private Boolean filterByView;
        private Boolean showPossibleWidget;
        private Boolean showParameterizedWidget;
        private Boolean showExtendedWidget;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "TESTING ";
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        public boolean getFilterByView() {
            if (this.filterByView == null) {
                return this.getFilterByViewDefault();
            }
            return this.filterByView;
        }

        public void setFilterByView(boolean filterByView) {
            this.filterByView = filterByView;
        }

        public boolean getShowPossibleWidget() {
            if (this.showPossibleWidget == null) {
                return false;
            }
            return this.showPossibleWidget;
        }

        public void setShowPossibleWidget(boolean showPossibleWidget) {
            this.showPossibleWidget = showPossibleWidget;
        }

        public boolean getShowParameterizedWidget() {
            if (this.showParameterizedWidget == null) {
                return false;
            }
            return this.showParameterizedWidget;
        }

        public void setShowParameterizedWidget(boolean showParameterizedWidget) {
            this.showParameterizedWidget = showParameterizedWidget;
        }

        public boolean getShowExtendedWidget() {
            if (this.showExtendedWidget == null) {
                return false;
            }
            return this.showExtendedWidget;
        }

        public void setShowExtendedWidget(boolean showExtendedWidget) {
            this.showExtendedWidget = showExtendedWidget;
        }

        public String getDefault() {
            return "dd/MM/yyyy HH:mm z";
        }

        public boolean getFilterByViewDefault() {
            return true;
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.dateFormat = json.getString("dateFormat");
            this.filterByView = json.getBoolean("filterByView");
            this.showPossibleWidget = json.getBoolean("showPossibleWidget");
            this.showParameterizedWidget = json.getBoolean("showParameterizedWidget");
            this.showExtendedWidget = json.getBoolean("showExtendedWidget");
            this.save();
            return true;
        }

        public FormValidation doCheckDateFormat(@QueryParameter String value) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(value);
                sdf.getClass();
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)Messages.Format_Error());
            }
        }
    }
}

