/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.nextbuildnumber;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import java.io.IOException;
import org.jvnet.hudson.plugins.nextbuildnumber.Messages;
import org.kohsuke.args4j.Argument;

@Extension
public class NextBuildNumberCommand
extends CLICommand {
    static final int INVALID_NEXT_BUILD_NUMBER = -2;
    @Argument(index=0, required=true, metaVar="JOB", usage="Name of the job")
    private TopLevelItem item;
    @Argument(index=1, required=true, metaVar="BUILD_NUMBER", usage="Next build number")
    private int number;

    public String getShortDescription() {
        return Messages.cliDescription();
    }

    public String getName() {
        return "set-next-build-number";
    }

    protected int run() throws IOException {
        this.item.checkPermission(Item.CONFIGURE);
        Job job = (Job)this.item;
        job.updateNextBuildNumber(this.number);
        if (job.getNextBuildNumber() == this.number) {
            return 0;
        }
        this.stderr.println(Messages.invalidBuildNumber(Integer.toString(this.number), Integer.toString(job.getNextBuildNumber())));
        return -2;
    }
}

