/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.nextbuildnumber;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.security.Permission;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import jenkins.branch.MultiBranchProject;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONException;
import org.jvnet.hudson.plugins.nextbuildnumber.Messages;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.springframework.security.access.AccessDeniedException;

public class NextBuildNumberAction
implements Action {
    private final Job job;

    NextBuildNumberAction(Job job) {
        this.job = job;
    }

    public String getIconFileName() {
        if (this.hasPermission(this.job)) {
            return "symbol-arrow-forward-outline plugin-ionicons-api";
        }
        return null;
    }

    public boolean hasPermission(Job job) {
        if (job.getParent() instanceof MultiBranchProject) {
            MultiBranchProject parentProject = (MultiBranchProject)job.getParent();
            boolean hasPermission = parentProject.getACL().hasPermission(this.getPermission());
            if (!hasPermission && parentProject.getParent() instanceof ComputedFolder) {
                hasPermission = ((ComputedFolder)parentProject.getParent()).getACL().hasPermission(this.getPermission());
            }
            return hasPermission;
        }
        return job.getACL().hasPermission(this.getPermission());
    }

    private void checkPermission(Job job) {
        if (job.getParent() instanceof MultiBranchProject) {
            MultiBranchProject parentProject = (MultiBranchProject)job.getParent();
            try {
                parentProject.getACL().checkPermission(this.getPermission());
            }
            catch (AccessDeniedException e) {
                if (parentProject.getParent() instanceof ComputedFolder) {
                    ((ComputedFolder)parentProject.getParent()).getACL().checkPermission(this.getPermission());
                }
                throw e;
            }
        } else {
            job.getACL().checkPermission(this.getPermission());
        }
    }

    public String getDisplayName() {
        return Messages.displayName();
    }

    public String getUrlName() {
        return "nextbuildnumber";
    }

    public Job getJob() {
        return this.job;
    }

    public Permission getPermission() {
        return Job.CONFIGURE;
    }

    public synchronized void doSubmit(StaplerRequest2 req, StaplerResponse2 resp) throws IOException, ServletException {
        this.checkPermission(this.job);
        try {
            int buildNumber = req.getSubmittedForm().getInt("nextBuildNumber");
            this.job.updateNextBuildNumber(buildNumber);
            resp.sendRedirect2(this.job.getAbsoluteUrl());
        }
        catch (JSONException e) {
            throw new ServletException("Build number must be an integer", (Throwable)e);
        }
    }

    @Extension
    public static class ActionInjector
    extends TransientActionFactory<Job> {
        public Collection<NextBuildNumberAction> createFor(Job p) {
            return Collections.singleton(new NextBuildNumberAction(p));
        }

        public Class<Job> type() {
            return Job.class;
        }
    }
}

