// CHECKSTYLE:OFF

package org.jvnet.hudson.plugins.nextbuildnumber;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code displayName}: {@code Set Next Build Number}.
     * 
     * @return
     *     {@code Set Next Build Number}
     */
    public static String displayName() {
        return holder.format("displayName");
    }

    /**
     * Key {@code displayName}: {@code Set Next Build Number}.
     * 
     * @return
     *     {@code Set Next Build Number}
     */
    public static Localizable _displayName() {
        return new Localizable(holder, "displayName");
    }

    /**
     * Key {@code invalidBuildNumber}: {@code Provided build number {0} is
     * less than last build number {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Provided build number {0} is less than last build number {1}.}
     */
    public static String invalidBuildNumber(Object arg0, Object arg1) {
        return holder.format("invalidBuildNumber", arg0, arg1);
    }

    /**
     * Key {@code invalidBuildNumber}: {@code Provided build number {0} is
     * less than last build number {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Provided build number {0} is less than last build number {1}.}
     */
    public static Localizable _invalidBuildNumber(Object arg0, Object arg1) {
        return new Localizable(holder, "invalidBuildNumber", arg0, arg1);
    }

    /**
     * Key {@code cliDescription}: {@code Set build number to be used for
     * next build.}.
     * 
     * @return
     *     {@code Set build number to be used for next build.}
     */
    public static String cliDescription() {
        return holder.format("cliDescription");
    }

    /**
     * Key {@code cliDescription}: {@code Set build number to be used for
     * next build.}.
     * 
     * @return
     *     {@code Set build number to be used for next build.}
     */
    public static Localizable _cliDescription() {
        return new Localizable(holder, "cliDescription");
    }

}
