/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view.search;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.nested_view.search.BuildDetails;
import hudson.plugins.nested_view.search.LinkableCandidate;
import hudson.plugins.nested_view.search.NamableWithClass;
import hudson.plugins.nested_view.search.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProjectWrapper {
    private final Optional<AbstractProject> project;
    private final boolean multiline;
    private final boolean projectInfo;
    private final int stats;
    private final int last;
    private final int builds;
    private final Query query;
    private final BuildDetails.SearchArtifactsOptions artifactSearch;
    private List<LinkableCandidate> details;
    private final Collection<String> matched;
    private int matchedBuildsCount;
    private int matchedArtifactsCount;
    private Date dateTime = new Date(Integer.MIN_VALUE);
    private final Date upperTimeLimit;
    private final Date lowerTimeLimit;

    public ProjectWrapper(Optional<AbstractProject> project, boolean multiline, boolean projectInfo, int stats, int last, int builds, Query query, Collection<String> matched) {
        this.project = project;
        this.multiline = multiline;
        this.projectInfo = projectInfo;
        this.stats = stats;
        this.last = last;
        this.builds = builds;
        this.query = query;
        this.matched = matched;
        this.artifactSearch = query != null ? new BuildDetails.SearchArtifactsOptions(query.getWithoutArgumentsSplit(), query.isSearchByArtifacts(), matched, query.getHow(), query.isInvert(), query.isBuildComment()) : null;
        if (this.isTimeLimit()) {
            this.lowerTimeLimit = this.upperTimeLimit = query.getTimeLimit();
        } else {
            this.upperTimeLimit = new Date(Long.MAX_VALUE);
            this.lowerTimeLimit = new Date(Integer.MIN_VALUE);
        }
    }

    private boolean isTimeLimit() {
        return this.query != null && this.query.getTimeLimit() != null;
    }

    public List<LinkableCandidate> getDetails() {
        return this.details;
    }

    public void createDetails() {
        this.details = this.createDetailsImpl();
    }

    public List<LinkableCandidate> createDetailsImpl() {
        if (this.project.isPresent()) {
            ArrayList<LinkableCandidate> result = new ArrayList<LinkableCandidate>();
            if (this.query != null && this.query.isJobComment() && this.project.get().getDescription().length() > 0) {
                result.add(new LinkableCandidate(this.project.get().getDescription()));
            }
            if (this.projectInfo) {
                int bc = this.project.get().getNextBuildNumber() - 1;
                String projectInfo = " builds count: " + bc + ",  is running  : " + this.project.get().isBuilding() + ",  in queue    : " + this.project.get().isInQueue() + ",  disabled    : " + this.project.get().isDisabled();
                result.add(new LinkableCandidate(projectInfo));
            }
            if (this.last >= 0) {
                String s = String.valueOf(this.last);
                if (s.contains("1")) {
                    BuildDetails lastBuild = this.specifiedBuild(" last build           : ", (Run)this.project.get().getLastBuild());
                    this.setDateTime(lastBuild);
                    result.add(lastBuild.toLinkable(this.project.get().getName(), this.artifactSearch, this));
                }
                if (s.contains("2")) {
                    BuildDetails lastStable = this.specifiedBuild(" last stable build    : ", this.project.get().getLastStableBuild());
                    this.setDateTime(lastStable);
                    result.add(lastStable.toLinkable(this.project.get().getName(), this.artifactSearch, this));
                }
                if (s.contains("3")) {
                    BuildDetails lastSuc = this.specifiedBuild(" last success build   : ", this.project.get().getLastSuccessfulBuild());
                    this.setDateTime(lastSuc);
                    result.add(lastSuc.toLinkable(this.project.get().getName(), this.artifactSearch, this));
                }
                if (s.contains("4")) {
                    BuildDetails lastUnst = this.specifiedBuild(" last unstable build  : ", this.project.get().getLastUnstableBuild());
                    result.add(lastUnst.toLinkable(this.project.get().getName(), this.artifactSearch, this));
                }
                if (s.contains("5")) {
                    BuildDetails lastFail = this.specifiedBuild(" last failed build    : ", this.project.get().getLastFailedBuild());
                    this.setDateTime(lastFail);
                    result.add(lastFail.toLinkable(this.project.get().getName(), this.artifactSearch, this));
                }
                if (s.contains("6")) {
                    BuildDetails lastUnsuc = this.specifiedBuild(" last unsuccess build : ", this.project.get().getLastUnsuccessfulBuild());
                    this.setDateTime(lastUnsuc);
                    result.add(lastUnsuc.toLinkable(this.project.get().getName(), this.artifactSearch, this));
                }
                if (s.contains("7")) {
                    BuildDetails lastComp = this.specifiedBuild(" last completed build : ", this.project.get().getLastCompletedBuild());
                    this.setDateTime(lastComp);
                    result.add(lastComp.toLinkable(this.project.get().getName(), this.artifactSearch, this));
                }
            }
            if (this.builds >= 0 || this.stats >= 0) {
                Iterator it = this.project.get().getBuilds().iterator();
                ArrayList<BuildDetails> buildsList = new ArrayList<BuildDetails>();
                HashMap<Result, Integer> summ = new HashMap<Result, Integer>();
                if (this.query != null && this.query.isStatsTable()) {
                    summ.put(Result.ABORTED, 0);
                    summ.put(Result.FAILURE, 0);
                    summ.put(Result.NOT_BUILT, 0);
                    summ.put(Result.SUCCESS, 0);
                    summ.put(Result.UNSTABLE, 0);
                    summ.put(null, 0);
                }
                int i1 = this.builds;
                for (int i2 = this.stats; it.hasNext() && (i1 > 0 || i2 > 0); --i1, --i2) {
                    Object q = it.next();
                    if (!(q instanceof AbstractBuild)) continue;
                    AbstractBuild b = (AbstractBuild)q;
                    if (i1 > 0) {
                        if (this.query != null && (this.query.isSearchByNvr() >= 0 || this.query.isSearchByBuildComment() >= 0)) {
                            for (String candidate : this.query.getWithoutArgumentsSplit()) {
                                boolean hit = false;
                                if (this.query.isSearchByNvr() != 1 || this.matched == null || !this.matched.contains(candidate)) {
                                    String displayName = b.getDisplayName();
                                    if (displayName == null) {
                                        displayName = "";
                                    }
                                    hit = this.tryMatch(buildsList, b, candidate, displayName);
                                }
                                if (!hit) {
                                    if (this.query.isSearchByBuildComment() == 1 && this.matched != null && this.matched.contains(candidate)) continue;
                                    String description = b.getDescription();
                                    if (description == null) {
                                        description = "";
                                    }
                                    hit = this.tryMatch(buildsList, b, candidate, description);
                                    continue;
                                }
                                break;
                            }
                        } else {
                            BuildDetails bb = this.buildToString((Run)b);
                            this.setDateTime(bb);
                            if (this.isBuildTimeValid(b)) {
                                buildsList.add(bb);
                            }
                        }
                    }
                    if (i2 <= 0) continue;
                    Integer counter = summ.getOrDefault(b.getResult(), 0);
                    counter = counter + 1;
                    if (!this.isBuildTimeValid(b)) continue;
                    summ.put(b.getResult(), counter);
                }
                if (this.stats >= 0) {
                    result.add(new LinkableCandidate(summ.entrySet().stream().sorted((t0, t1) -> {
                        String l1 = this.resultToString((Result)t1.getKey());
                        String l0 = this.resultToString((Result)t0.getKey());
                        return l1.compareTo(l0);
                    }).map(a -> this.resultToString((Result)a.getKey()) + ": " + String.valueOf(a.getValue()) + "x").collect(Collectors.joining(", "))));
                }
                if (this.builds >= 0) {
                    for (BuildDetails a2 : buildsList) {
                        LinkableCandidate linkableCandidate = a2.toLinkable(this.project.get().getName(), this.artifactSearch, this);
                        result.add(linkableCandidate);
                    }
                }
                this.matchedBuildsCount = buildsList.size();
            }
            if (this.multiline && result.size() > 0) {
                result.add(0, new LinkableCandidate(""));
            }
            return result;
        }
        return Arrays.asList(new LinkableCandidate("N/A"));
    }

    private boolean tryMatch(List<BuildDetails> buildsList, AbstractBuild b, String candidate, String displayName) {
        boolean hit = false;
        boolean matches = NamableWithClass.matchSingle(displayName, candidate, this.query.getHow());
        if (!this.query.isInvert()) {
            if (matches) {
                BuildDetails bb = this.buildToString((Run)b);
                hit = true;
                this.setDateTime(bb);
                if (this.isBuildTimeValid(b)) {
                    buildsList.add(bb);
                }
            }
        } else if (!matches) {
            BuildDetails bb = this.buildToString((Run)b);
            hit = true;
            this.setDateTime(bb);
            if (this.isBuildTimeValid(b)) {
                buildsList.add(bb);
            }
        }
        return hit;
    }

    private boolean isBuildTimeValid(AbstractBuild b) {
        return b.getTime().getTime() >= this.lowerTimeLimit.getTime();
    }

    private String resultToString(Result r) {
        return r == null ? "RUNNING" : r.toString();
    }

    private void setDateTime(BuildDetails build) {
        this.dateTime = new Date(Math.max(this.dateTime.getTime(), build.getDateTime()));
    }

    public long getDateTime() {
        return this.dateTime.getTime();
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    private BuildDetails specifiedBuild(String s, Run lastBuild) {
        int archives = 0;
        if (this.query.isSearchByArtifacts() > 0) {
            archives = Math.max(0, this.query.getMaxArtifacts());
        }
        return lastBuild != null ? new BuildDetails(s, lastBuild, archives) : new BuildDetails(s, null, null, null, null, null, new Date(0L), new ArrayList<Run.Artifact>(0));
    }

    private BuildDetails buildToString(Run ab) {
        return this.specifiedBuild("", ab);
    }

    public boolean isStillValid() {
        if (this.project.isPresent()) {
            if (this.query == null) {
                return true;
            }
            if (this.query.isSearchByNvr() > 0) {
                return !this.query.isNvrFinalFilter() || this.matchedBuildsCount > 0;
            }
            if (this.query.isSearchByBuildComment() > 0) {
                return !this.query.isBuildCommentFinalFilter() || this.matchedBuildsCount > 0;
            }
            if (this.query.isSearchByArtifacts() > 0) {
                return !this.query.isArtifactFinalFilter() || this.matchedArtifactsCount > 0;
            }
            return true;
        }
        return true;
    }

    public void addArtifactCouont() {
        ++this.matchedArtifactsCount;
    }
}

