/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.nested_view.search;

import hudson.model.AbstractProject;
import hudson.model.View;
import hudson.plugins.nested_view.NestedView;
import hudson.plugins.nested_view.search.Query;
import java.util.Optional;
import java.util.Set;
import jenkins.model.Jenkins;

public class NamableWithClass {
    private final String name;
    private final String fullPath;
    private final String description;
    private Object item;

    public NamableWithClass(Object item, String name, String fullPath, String description) {
        this.item = item;
        this.name = name;
        this.fullPath = fullPath;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getUsefulName() {
        if (this.item instanceof AbstractProject) {
            return this.name;
        }
        if (this.item instanceof NestedView) {
            return this.fullPath + "/";
        }
        return this.fullPath;
    }

    public String getUrl() {
        String rootUrl = Jenkins.get().getRootUrl();
        if (rootUrl.endsWith("/")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        if (this.item instanceof AbstractProject) {
            return rootUrl + "/job/" + this.name;
        }
        return rootUrl + this.getFullPath().replace("/", "/view/");
    }

    public boolean matches(Query query, Set<String> matched) {
        if (query.isInvert()) {
            return !this.matchesImpl(query, matched);
        }
        return this.matchesImpl(query, matched);
    }

    private boolean matchesImpl(Query query, Set<String> matched) {
        String nameOrPath = this.getFullPath();
        if (query.getPart().equals("p")) {
            nameOrPath = this.getName();
        }
        if (query.getQuery().contains("##")) {
            nameOrPath = this.getDescription();
        }
        boolean clazzPass = false;
        if (query.getWhere().contains("j") && this.item instanceof AbstractProject) {
            clazzPass = true;
        }
        if (query.getWhere().contains("w") && (this.item instanceof View || this.item instanceof NestedView)) {
            clazzPass = true;
        }
        if (query.getWhere().contains("n") && this.item instanceof NestedView) {
            clazzPass = true;
        }
        if (query.getWhere().contains("v") && this.item instanceof View && !(this.item instanceof NestedView)) {
            clazzPass = true;
        }
        if (!clazzPass) {
            return false;
        }
        if (query.getBool().equals("a")) {
            String[] parts = query.getWithoutArgumentsSplit();
            boolean r = true;
            for (String part : parts) {
                if (!this.matchSingle(nameOrPath, part, query)) {
                    r = false;
                    continue;
                }
                matched.add(part);
            }
            return r;
        }
        if (query.getBool().equals("o")) {
            String[] parts = query.getWithoutArgumentsSplit();
            boolean r = false;
            for (String part : parts) {
                if (!this.matchSingle(nameOrPath, part, query)) continue;
                r = true;
                matched.add(part);
            }
            return r;
        }
        if (this.matchSingle(nameOrPath, query.getWithoutArguments(), query)) {
            matched.add(query.getWithoutArguments());
            return true;
        }
        return false;
    }

    private boolean matchSingle(String nameOrPath, String queryOrPart, Query query) {
        return NamableWithClass.matchSingle(nameOrPath, queryOrPart, query.getHow());
    }

    public static boolean matchSingle(String nameOrPath, String queryOrPart, String how) {
        if (how.equals("s")) {
            return nameOrPath.startsWith(queryOrPart);
        }
        if (how.equals("e")) {
            return nameOrPath.endsWith(queryOrPart);
        }
        if (how.equals("r")) {
            return nameOrPath.matches(queryOrPart);
        }
        if (how.equals("R")) {
            return nameOrPath.matches(".*" + queryOrPart + ".*");
        }
        if (how.equals("q")) {
            return nameOrPath.equalsIgnoreCase(queryOrPart);
        }
        if (how.equals("Q")) {
            return nameOrPath.equals(queryOrPart);
        }
        return nameOrPath.contains(queryOrPart);
    }

    public Optional<AbstractProject> getProject() {
        Object object = this.item;
        if (object instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)object;
            return Optional.of(project);
        }
        return Optional.empty();
    }
}

