// CHECKSTYLE:OFF

package hudson.plugins.nested_view;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code viewHealth}: {@code Average health of {0} jobs}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Average health of {0} jobs}
     */
    public static String viewHealth(Object arg0) {
        return holder.format("viewHealth", arg0);
    }

    /**
     * Key {@code viewHealth}: {@code Average health of {0} jobs}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Average health of {0} jobs}
     */
    public static Localizable _viewHealth(Object arg0) {
        return new Localizable(holder, "viewHealth", arg0);
    }

    /**
     * Key {@code noJobs}: {@code Subview contains no jobs}.
     * 
     * @return
     *     {@code Subview contains no jobs}
     */
    public static String noJobs() {
        return holder.format("noJobs");
    }

    /**
     * Key {@code noJobs}: {@code Subview contains no jobs}.
     * 
     * @return
     *     {@code Subview contains no jobs}
     */
    public static Localizable _noJobs() {
        return new Localizable(holder, "noJobs");
    }

    /**
     * Key {@code displayName}: {@code Nested View}.
     * 
     * @return
     *     {@code Nested View}
     */
    public static String displayName() {
        return holder.format("displayName");
    }

    /**
     * Key {@code displayName}: {@code Nested View}.
     * 
     * @return
     *     {@code Nested View}
     */
    public static Localizable _displayName() {
        return new Localizable(holder, "displayName");
    }

}
