/*
 * Decompiled with CFR 0.152.
 */
package com.chikli.hudson.plugin.naginator;

import com.chikli.hudson.plugin.naginator.NaginatorAction;
import com.chikli.hudson.plugin.naginator.ScheduleDelay;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import org.kohsuke.stapler.DataBoundConstructor;

public class ProgressiveDelay
extends ScheduleDelay {
    private int increment;
    private int max;

    @DataBoundConstructor
    public ProgressiveDelay(int increment, int max) {
        this.increment = increment;
        this.max = max;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public int computeScheduleDelay(AbstractBuild failedBuild) {
        int n = this.getRetryCount(failedBuild);
        int factor = (n + 1) * (n + 2) / 2;
        int delay = this.increment * factor;
        return this.max <= 0 ? delay : Math.min(delay, this.max);
    }

    private int getRetryCount(AbstractBuild<?, ?> failedBuild) {
        NaginatorAction action = (NaginatorAction)failedBuild.getAction(NaginatorAction.class);
        if (action == null) {
            return 0;
        }
        return action.getRetryCount();
    }

    @Extension
    public static class DescriptorImpl
    extends ScheduleDelay.ScheduleDelayDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Progressive";
        }
    }
}

