/*
 * Decompiled with CFR 0.152.
 */
package com.chikli.hudson.plugin.naginator;

import com.chikli.hudson.plugin.naginator.Messages;
import com.chikli.hudson.plugin.naginator.NaginatorPublisherScheduleAction;
import com.chikli.hudson.plugin.naginator.NoChildStrategy;
import com.chikli.hudson.plugin.naginator.ProgressiveDelay;
import com.chikli.hudson.plugin.naginator.RegexpForMatrixStrategy;
import com.chikli.hudson.plugin.naginator.ScheduleDelay;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class NaginatorPublisher
extends Notifier {
    public static final long DEFAULT_REGEXP_TIMEOUT_MS = 30000L;
    private final String regexpForRerun;
    private final boolean rerunIfUnstable;
    private final boolean rerunMatrixPart;
    private final boolean checkRegexp;
    @Deprecated
    private transient Boolean regexpForMatrixParent;
    private RegexpForMatrixStrategy regexpForMatrixStrategy;
    private NoChildStrategy noChildStrategy;
    private ScheduleDelay delay;
    private int maxSchedule;
    private static final Logger LOGGER = Logger.getLogger(NaginatorPublisher.class.getName());

    public NaginatorPublisher(String regexpForRerun, boolean rerunIfUnstable, boolean checkRegexp) {
        this(regexpForRerun, rerunIfUnstable, false, checkRegexp, 0, new ProgressiveDelay(300, 10800));
    }

    @DataBoundConstructor
    public NaginatorPublisher(String regexpForRerun, boolean rerunIfUnstable, boolean rerunMatrixPart, boolean checkRegexp, int maxSchedule, ScheduleDelay delay) {
        this.regexpForRerun = regexpForRerun;
        this.rerunIfUnstable = rerunIfUnstable;
        this.rerunMatrixPart = rerunMatrixPart;
        this.checkRegexp = checkRegexp;
        this.maxSchedule = maxSchedule;
        this.delay = delay;
        this.setRegexpForMatrixStrategy(RegexpForMatrixStrategy.TestParent);
    }

    @Deprecated
    public NaginatorPublisher(String regexpForRerun, boolean rerunIfUnstable, boolean rerunMatrixPart, boolean checkRegexp, boolean regexpForMatrixParent, int maxSchedule, ScheduleDelay delay) {
        this(regexpForRerun, rerunIfUnstable, rerunMatrixPart, checkRegexp, maxSchedule, delay);
        this.setRegexpForMatrixParent(regexpForMatrixParent);
    }

    public Object readResolve() {
        if (this.delay == null) {
            this.delay = new ProgressiveDelay(300, 10800);
        }
        if (this.regexpForMatrixStrategy == null) {
            if (this.regexpForMatrixParent != null) {
                this.setRegexpForMatrixParent(this.regexpForMatrixParent);
                this.regexpForMatrixParent = null;
            } else {
                this.setRegexpForMatrixStrategy(RegexpForMatrixStrategy.TestParent);
            }
        }
        return this;
    }

    public boolean isRerunIfUnstable() {
        return this.rerunIfUnstable;
    }

    public boolean isRerunMatrixPart() {
        return this.rerunMatrixPart;
    }

    @DataBoundSetter
    public void setNoChildStrategy(@NonNull NoChildStrategy noChildStrategy) {
        this.noChildStrategy = noChildStrategy;
    }

    @NonNull
    public NoChildStrategy getNoChildStrategy() {
        return this.noChildStrategy != null ? this.noChildStrategy : NoChildStrategy.getDefault();
    }

    public boolean isCheckRegexp() {
        return this.checkRegexp;
    }

    @Deprecated
    public boolean isRegexpForMatrixParent() {
        return this.getRegexpForMatrixStrategy() == RegexpForMatrixStrategy.TestParent;
    }

    private void setRegexpForMatrixParent(boolean regexpForMatrixParent) {
        this.setRegexpForMatrixStrategy(regexpForMatrixParent ? RegexpForMatrixStrategy.TestParent : RegexpForMatrixStrategy.TestChildrenRetriggerMatched);
    }

    public String getRegexpForRerun() {
        return this.regexpForRerun;
    }

    @DataBoundSetter
    public void setRegexpForMatrixStrategy(@NonNull RegexpForMatrixStrategy regexpForMatrixStrategy) {
        this.regexpForMatrixStrategy = regexpForMatrixStrategy;
    }

    @NonNull
    public RegexpForMatrixStrategy getRegexpForMatrixStrategy() {
        return this.regexpForMatrixStrategy;
    }

    public ScheduleDelay getDelay() {
        return this.delay;
    }

    public int getMaxSchedule() {
        return this.maxSchedule;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build instanceof MatrixRun) {
            MatrixBuild parent;
            if (this.getRegexpForMatrixStrategy() == RegexpForMatrixStrategy.TestChildrenRetriggerMatched && !this.isRerunMatrixPart()) {
                listener.getLogger().println("[Naginator] Warning: TestChildrenRetriggerMatched doesn't work without rerunMatrixPart");
            }
            if ((parent = ((MatrixRun)build).getParentBuild()).getAction(NaginatorPublisherScheduleAction.class) == null) {
                parent.addAction((Action)new NaginatorPublisherScheduleAction(this));
            }
        } else {
            build.addAction((Action)new NaginatorPublisherScheduleAction(this));
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private long regexpTimeoutMs = 30000L;

        public DescriptorImpl() {
            this.load();
        }

        public long getRegexpTimeoutMs() {
            return this.regexpTimeoutMs;
        }

        public void setRegexpTimeoutMs(long regexpTimeoutMs) {
            this.regexpTimeoutMs = regexpTimeoutMs;
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.setRegexpTimeoutMs(json.getLong("regexpTimeoutMs"));
            boolean result = super.configure(req, json);
            this.save();
            return result;
        }

        @NonNull
        public String getDisplayName() {
            return "Retry build after failure";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean isMatrixProject(Object it) {
            return it instanceof MatrixProject;
        }

        public FormValidation doCheckRegexpForMatrixStrategy(@QueryParameter RegexpForMatrixStrategy value, @QueryParameter boolean rerunMatrixPart) {
            if (value == RegexpForMatrixStrategy.TestChildrenRetriggerMatched && !rerunMatrixPart) {
                return FormValidation.warning((String)Messages.NaginatorPublisher_RegexpForMatrixStrategy_RerunMatrixPartShouldBeEnabled());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillRegexpForMatrixStrategyItems() {
            ListBoxModel ret = new ListBoxModel();
            for (RegexpForMatrixStrategy strategy : RegexpForMatrixStrategy.values()) {
                ret.add(strategy.getDisplayName(), strategy.name());
            }
            return ret;
        }
    }
}

