/*
 * Decompiled with CFR 0.152.
 */
package com.chikli.hudson.plugin.naginator;

import com.chikli.hudson.plugin.naginator.NaginatorAction;
import com.chikli.hudson.plugin.naginator.NaginatorMatrixAction;
import com.chikli.hudson.plugin.naginator.NaginatorPublisher;
import com.chikli.hudson.plugin.naginator.NaginatorRetryAction;
import com.chikli.hudson.plugin.naginator.NaginatorScheduleAction;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.Combination;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class NaginatorListener
extends RunListener<AbstractBuild<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(NaginatorListener.class.getName());

    public void onCompleted(AbstractBuild<?, ?> build, @NonNull TaskListener listener) {
        if (build == null || build instanceof MatrixRun) {
            return;
        }
        int retryCount = NaginatorListener.calculateRetryCount(build);
        List actions = build.getActions(NaginatorScheduleAction.class);
        for (NaginatorScheduleAction action : actions) {
            if (!action.shouldSchedule((Run<?, ?>)build, listener, retryCount)) continue;
            int n = action.getDelay().computeScheduleDelay(build);
            LOGGER.log(Level.FINE, "about to try to schedule a build #{0} in {1} seconds for {2}", new Object[]{build.getNumber(), n, build.getProject().getName()});
            ArrayList<Combination> combsToRerun = new ArrayList<Combination>();
            if (action.isRerunMatrixPart() && build instanceof MatrixBuild) {
                MatrixBuild mb = (MatrixBuild)build;
                List matrixRuns = mb.getRuns();
                for (MatrixRun r : matrixRuns) {
                    if (r.getNumber() != build.getNumber() || !action.shouldScheduleForMatrixRun(r, listener)) continue;
                    LOGGER.log(Level.FINE, "add combination to matrix rerun ({0})", r.getParent().getCombination().toString());
                    combsToRerun.add(r.getParent().getCombination());
                }
            }
            if (!combsToRerun.isEmpty()) {
                LOGGER.log(Level.FINE, "schedule matrix rebuild");
                this.scheduleMatrixBuild(build, combsToRerun, n, retryCount + 1, action.getMaxSchedule());
                continue;
            }
            if (build instanceof MatrixBuild && action.isRerunMatrixPart()) {
                switch (action.getNoChildStrategy()) {
                    case RerunWhole: {
                        this.scheduleBuild(build, n, retryCount + 1, action.getMaxSchedule());
                        break;
                    }
                    case RerunEmpty: {
                        LOGGER.log(Level.FINE, "schedule matrix rebuild");
                        this.scheduleMatrixBuild(build, combsToRerun, n, retryCount + 1, action.getMaxSchedule());
                        break;
                    }
                    case DontRun: {
                        break;
                    }
                }
                continue;
            }
            this.scheduleBuild(build, n, retryCount + 1, action.getMaxSchedule());
        }
    }

    public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        NaginatorAction action;
        AbstractBuild rootBuild = build.getRootBuild();
        if (rootBuild == null) {
            rootBuild = build;
        }
        if ((action = (NaginatorAction)rootBuild.getAction(NaginatorAction.class)) == null) {
            return null;
        }
        return new Environment(this){
            final /* synthetic */ NaginatorListener this$0;
            {
                this.this$0 = this$0;
            }

            public void buildEnvVars(Map<String, String> env) {
                env.put("NAGINATOR_COUNT", Integer.toString(action.getRetryCount()));
                env.put("NAGINATOR_MAXCOUNT", Integer.toString(action.getMaxRetryCount()));
                Integer parentBuildNumber = action.getParentBuildNumber();
                if (parentBuildNumber != null) {
                    env.put("NAGINATOR_BUILD_NUMBER", parentBuildNumber.toString());
                }
            }
        };
    }

    @Deprecated
    public boolean canSchedule(Run build, NaginatorPublisher naginator) {
        int n;
        Run r = build;
        int max = naginator.getMaxSchedule();
        if (max <= 0) {
            return true;
        }
        for (n = 0; r != null && r.getAction(NaginatorAction.class) != null && n < max; r = r.getPreviousBuild(), ++n) {
        }
        return n < max;
    }

    public static int calculateRetryCount(@NonNull Run<?, ?> r) {
        NaginatorAction naginatorAction = (NaginatorAction)r.getAction(NaginatorAction.class);
        if (naginatorAction == null) {
            return 0;
        }
        if (naginatorAction.getRetryCount() > 0) {
            return naginatorAction.getRetryCount();
        }
        int n = 0;
        while (r != null && r.getAction(NaginatorAction.class) != null) {
            r = r.getPreviousBuild();
            ++n;
        }
        return n;
    }

    @Deprecated
    public boolean scheduleMatrixBuild(AbstractBuild<?, ?> build, List<Combination> combinations, int n) {
        return this.scheduleMatrixBuild(build, combinations, n, NaginatorListener.calculateRetryCount(build), 0);
    }

    private boolean scheduleMatrixBuild(AbstractBuild<?, ?> build, List<Combination> combinations, int delay, int retryCount, int maxRetryCount) {
        NaginatorMatrixAction nma = new NaginatorMatrixAction((Run<?, ?>)build, retryCount, maxRetryCount);
        for (Combination c : combinations) {
            nma.addCombinationToRerun(c);
        }
        return NaginatorRetryAction.scheduleBuild(build, delay, nma);
    }

    @Deprecated
    public boolean scheduleBuild(AbstractBuild<?, ?> build, int n) {
        return this.scheduleBuild(build, n, NaginatorListener.calculateRetryCount(build), 0);
    }

    private boolean scheduleBuild(AbstractBuild<?, ?> build, int n, int retryCount, int maxRetryCount) {
        return NaginatorRetryAction.scheduleBuild(build, n, retryCount, maxRetryCount);
    }
}

