/*
 * Decompiled with CFR 0.152.
 */
package com.chikli.hudson.plugin.naginator;

import com.chikli.hudson.plugin.naginator.NoChildStrategy;
import com.chikli.hudson.plugin.naginator.ProgressiveDelay;
import com.chikli.hudson.plugin.naginator.ScheduleDelay;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.matrix.MatrixRun;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.model.TaskListener;

public class NaginatorScheduleAction
extends InvisibleAction {
    private final int maxSchedule;
    private final ScheduleDelay delay;
    private final boolean rerunMatrixPart;

    public NaginatorScheduleAction() {
        this(0);
    }

    public NaginatorScheduleAction(int maxSchedule) {
        this(maxSchedule, null, false);
    }

    public NaginatorScheduleAction(int maxSchedule, @CheckForNull ScheduleDelay delay, boolean rerunMatrixPart) {
        this.maxSchedule = maxSchedule;
        this.delay = delay != null ? delay : new ProgressiveDelay(300, 10800);
        this.rerunMatrixPart = rerunMatrixPart;
    }

    public int getMaxSchedule() {
        return this.maxSchedule;
    }

    @NonNull
    public ScheduleDelay getDelay() {
        return this.delay;
    }

    public boolean isRerunMatrixPart() {
        return this.rerunMatrixPart;
    }

    public boolean shouldSchedule(@NonNull Run<?, ?> run, @NonNull TaskListener listener, int retryCount) {
        return this.getMaxSchedule() <= 0 || retryCount < this.getMaxSchedule();
    }

    public boolean shouldScheduleForMatrixRun(@NonNull MatrixRun run, @NonNull TaskListener listener) {
        return true;
    }

    @NonNull
    public NoChildStrategy getNoChildStrategy() {
        return NoChildStrategy.getDefault();
    }
}

