/*
 * Decompiled with CFR 0.152.
 */
package com.chikli.hudson.plugin.naginator;

import com.chikli.hudson.plugin.naginator.NaginatorAction;
import com.chikli.hudson.plugin.naginator.NaginatorCause;
import com.chikli.hudson.plugin.naginator.NaginatorListener;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.ParametersAction;
import hudson.model.Run;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class NaginatorRetryAction
implements Action {
    private boolean hasPermission() {
        Run run = (Run)Stapler.getCurrentRequest2().findAncestorObject(Run.class);
        if (run == null) {
            return false;
        }
        if (!(run instanceof AbstractBuild)) {
            return false;
        }
        return run.getParent().hasPermission(Item.BUILD);
    }

    public String getIconFileName() {
        return this.hasPermission() ? "symbol-arrow-redo-outline plugin-ionicons-api" : null;
    }

    public String getDisplayName() {
        return this.hasPermission() ? "Retry" : null;
    }

    public String getUrlName() {
        return this.hasPermission() ? "retry" : null;
    }

    @RequirePOST
    public void doIndex(StaplerResponse2 res, @AncestorInPath @CheckForNull AbstractBuild<?, ?> build) throws IOException {
        if (build == null) {
            res.sendError(404);
            return;
        }
        ((AbstractProject)build.getParent()).checkPermission(Item.BUILD);
        NaginatorRetryAction.scheduleBuild2(build, 0, new NaginatorAction((Run<?, ?>)build, NaginatorListener.calculateRetryCount(build), 0), true);
        res.sendRedirect2(build.getUpUrl());
    }

    static boolean scheduleBuild(AbstractBuild<?, ?> build, int delay, int retryCount, int maxRetryCount) {
        return NaginatorRetryAction.scheduleBuild(build, delay, new NaginatorAction((Run<?, ?>)build, retryCount, maxRetryCount));
    }

    static boolean scheduleBuild(AbstractBuild<?, ?> build, int delay, NaginatorAction action) {
        return NaginatorRetryAction.scheduleBuild2(build, delay, action, false);
    }

    static boolean scheduleBuild2(AbstractBuild<?, ?> build, int delay, NaginatorAction action, boolean replaceUser) {
        ArrayList<NaginatorAction> actions = new ArrayList<NaginatorAction>();
        NaginatorCause cause = new NaginatorCause(build);
        actions.add(action);
        action.setCause(cause);
        actions.add((NaginatorAction)build.getAction(ParametersAction.class));
        actions.add((NaginatorAction)NaginatorRetryAction.getCauseAction(build, replaceUser, cause));
        return build.getProject().scheduleBuild2(delay, actions.toArray(new Action[0])) != null;
    }

    private static CauseAction getCauseAction(AbstractBuild<?, ?> build, boolean replaceUser, NaginatorCause cause) {
        ArrayList currentCauses = new ArrayList(build.getCauses());
        List newCauses = currentCauses.stream().filter(c -> (!(c instanceof Cause.UserIdCause) || !replaceUser) && !(c instanceof NaginatorCause)).collect(Collectors.toList());
        newCauses.add(cause);
        if (replaceUser) {
            newCauses.add(new Cause.UserIdCause());
        }
        return new CauseAction(newCauses);
    }
}

