/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinci.plugins.mock_slave;

final class UnboundedBlockingByteQueue {
    private final String id;
    private final float growth;
    private byte[] buf;
    private int start;
    private int size;

    UnboundedBlockingByteQueue(String id, int initialCapacity, float growth) {
        this.id = id;
        if (initialCapacity < 1 || growth <= 1.0f) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[initialCapacity];
        this.growth = growth;
    }

    private boolean invariants() {
        return this.start >= 0 && this.start < this.buf.length && this.size >= 0 && this.size <= this.buf.length;
    }

    synchronized void write(byte b) {
        assert (this.invariants());
        if (this.size == this.buf.length) {
            byte[] buf2 = new byte[Math.round((float)this.size * this.growth + 1.0f)];
            assert (buf2.length > this.buf.length);
            System.arraycopy(this.buf, this.start, buf2, 0, this.size - this.start);
            System.arraycopy(this.buf, 0, buf2, this.size - this.start, this.start);
            this.buf = buf2;
            this.start = 0;
        } else if (this.size == 0) {
            this.notifyAll();
        }
        this.buf[(this.start + this.size) % this.buf.length] = b;
        ++this.size;
        assert (this.invariants());
    }

    synchronized byte read() throws InterruptedException {
        assert (this.invariants());
        while (this.size == 0) {
            this.wait();
            assert (this.invariants());
        }
        byte b = this.buf[this.start];
        this.start = (this.start + 1) % this.buf.length;
        --this.size;
        assert (this.invariants());
        return b;
    }

    synchronized int available() {
        assert (this.invariants());
        return this.size;
    }

    void log(String msg) {
        System.err.println("@" + this.id + " " + msg);
    }
}

