/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.mocksecurityrealm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jenkins.model.IdStrategy;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class MockSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private final String data;
    private final Long delayMillis;
    private final boolean randomDelay;
    private transient boolean outage;
    private final IdStrategy userIdStrategy;
    private final IdStrategy groupIdStrategy;
    private transient ThreadLocal<Random> entropy;
    private transient int sqrtDelayMillis;

    @DataBoundConstructor
    public MockSecurityRealm(String data, Long delayMillis, boolean randomDelay, IdStrategy userIdStrategy, IdStrategy groupIdStrategy) {
        this.data = data;
        this.randomDelay = randomDelay;
        this.userIdStrategy = userIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : userIdStrategy;
        this.groupIdStrategy = groupIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : groupIdStrategy;
        this.delayMillis = delayMillis == null || delayMillis <= 0L ? null : delayMillis;
    }

    public void outage() {
        this.outage = true;
    }

    public void endOutage() {
        this.outage = false;
    }

    public String getData() {
        return this.data;
    }

    public Long getDelayMillis() {
        return this.delayMillis;
    }

    public boolean isRandomDelay() {
        return this.randomDelay;
    }

    public IdStrategy getUserIdStrategy() {
        return this.userIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : this.userIdStrategy;
    }

    public IdStrategy getGroupIdStrategy() {
        return this.groupIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : this.groupIdStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="On purpose to introduce a delay")
    private void doDelay() {
        if (this.delayMillis == null) {
            return;
        }
        if (this.randomDelay) {
            MockSecurityRealm mockSecurityRealm = this;
            synchronized (mockSecurityRealm) {
                if (this.entropy == null) {
                    this.entropy = new ThreadLocal<Random>(){

                        @Override
                        protected Random initialValue() {
                            return new Random();
                        }
                    };
                    this.sqrtDelayMillis = (int)Math.sqrt(this.delayMillis.longValue());
                }
                long effectiveDelayMillis = this.delayMillis - (long)this.sqrtDelayMillis + (long)this.entropy.get().nextInt(this.sqrtDelayMillis * 2);
                try {
                    Thread.sleep(effectiveDelayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            Thread.sleep(this.delayMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Map<String, Set<String>> usersAndGroups() {
        TreeMap<String, Set<String>> r = new TreeMap<String, Set<String>>((Comparator<String>)this.getUserIdStrategy());
        for (String line : this.data.split("\r?\n")) {
            String s = line.trim();
            if (s.isEmpty()) continue;
            String[] names = s.split(" +");
            TreeSet<String> groups = new TreeSet<String>((Comparator<String>)this.getGroupIdStrategy());
            groups.addAll(Arrays.asList(names).subList(1, names.length));
            r.put(names[0], groups);
        }
        return r;
    }

    protected UserDetails authenticate2(String username, String password) throws AuthenticationException {
        this.troubles();
        UserDetails u = this.loadUserByUsername2(username);
        if (!password.equals(u.getUsername())) {
            throw new BadCredentialsException(password);
        }
        return u;
    }

    private void troubles() {
        this.mayOutage();
        this.doDelay();
    }

    private void mayOutage() {
        if (this.outage) {
            throw new UserMayOrMayNotExistException2("Outage");
        }
    }

    public UserDetails loadUserByUsername2(String username) throws UsernameNotFoundException {
        this.troubles();
        IdStrategy idStrategy = this.getUserIdStrategy();
        for (Map.Entry<String, Set<String>> entry : this.usersAndGroups().entrySet()) {
            if (!idStrategy.equals(entry.getKey(), username)) continue;
            ArrayList<Object> gs = new ArrayList<Object>();
            gs.add(AUTHENTICATED_AUTHORITY2);
            for (String g : entry.getValue()) {
                gs.add(new SimpleGrantedAuthority(g));
            }
            return new User(entry.getKey(), "", true, true, true, true, gs);
        }
        throw new UsernameNotFoundException(username);
    }

    public GroupDetails loadGroupByGroupname2(String groupname, boolean fetchMembers) throws UsernameNotFoundException {
        this.troubles();
        IdStrategy idStrategy = this.getGroupIdStrategy();
        for (Set<String> groups : this.usersAndGroups().values()) {
            for (final String group : groups) {
                if (!idStrategy.equals(group, groupname)) continue;
                return new GroupDetails(){

                    public String getName() {
                        return group;
                    }

                    public Set<String> getMembers() {
                        IdStrategy idStrategy = MockSecurityRealm.this.getGroupIdStrategy();
                        TreeSet<String> r = new TreeSet<String>();
                        block0: for (Map.Entry<String, Set<String>> entry : MockSecurityRealm.this.usersAndGroups().entrySet()) {
                            for (String groupname : entry.getValue()) {
                                if (!idStrategy.equals(group, groupname)) continue;
                                r.add(entry.getKey());
                                continue block0;
                            }
                        }
                        return r;
                    }
                };
            }
        }
        throw new UsernameNotFoundException(groupname);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "Mock Security Realm";
        }

        public IdStrategy getDefaultIdStrategy() {
            return IdStrategy.CASE_INSENSITIVE;
        }
    }
}

