/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import hudson.Extension;
import hudson.cli.CLICommand;
import jenkins.model.Jenkins;
import jenkins.plugin.mockloadbuilder.MockProjectFactory;
import org.kohsuke.args4j.Argument;

@Extension
public class SetMockLoadForkPolicy
extends CLICommand {
    @Argument(index=0, metaVar="MODE", usage="Either `fork` or `nofork`", required=true)
    public String mode;

    public String getShortDescription() {
        return "Changes the fork policy of the mock load builder";
    }

    protected int run() throws Exception {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        MockProjectFactory.mode = "nofork".equalsIgnoreCase(this.mode);
        if (MockProjectFactory.mode) {
            this.stdout.println("Mock load will be generated on the agent's JVM without forking");
        } else {
            this.stdout.println("Mock load will be generated on the agent by forking a JVM");
        }
        return 0;
    }
}

