/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.User;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugin.mockloadbuilder.Helper;
import org.kohsuke.args4j.Argument;

@Extension
public class ScheduleMockLoadJobs
extends CLICommand {
    @Argument(index=0, metaVar="COUNT", usage="Number of jobs to create", required=true)
    public Integer count;
    @Argument(index=1, metaVar="FOLDER", usage="Where to create the jobs")
    public String group;

    public String getShortDescription() {
        return "Schedule N mock jobs in the given folder";
    }

    protected int run() throws Exception {
        Jenkins.get().checkPermission(Item.BUILD);
        User currentUser = User.current();
        ModifiableTopLevelItemGroup ig = Helper.resolveFolder(this.group);
        int index = 0;
        List allItems = ig.getAllItems(BuildableItem.class);
        Collections.shuffle(allItems);
        for (BuildableItem i : allItems) {
            if (index >= this.count || !i.getName().startsWith("mock-load-job-")) continue;
            i.scheduleBuild((Cause)new Cause.UserIdCause(currentUser == null ? null : currentUser.getId()));
            this.stdout.println("Scheduled " + i.getFullName());
            ++index;
        }
        return 0;
    }
}

