/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import hudson.matrix.Axis;
import hudson.matrix.AxisList;
import hudson.matrix.MatrixProject;
import hudson.matrix.TextAxis;
import hudson.model.TopLevelItemDescriptor;
import java.io.IOException;
import jenkins.model.BuildDiscarder;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugin.mockloadbuilder.Config;
import jenkins.plugin.mockloadbuilder.MockProjectFactory;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"matrix-project"})
public class MatrixMockProjectFactory
extends MockProjectFactory {
    @Override
    public int getFrequency() {
        return Config.get().getMatrixFrequency();
    }

    @Override
    public int getMultiplier() {
        return Config.get().getMatrixMultiplier();
    }

    @Override
    public void create(ModifiableTopLevelItemGroup ig, String name, Long averageDuration, boolean fastRotate) throws IOException {
        MatrixProject project = this.createProject(ig, name);
        project.setBuildDiscarder((BuildDiscarder)this.createBuildDiscarder(fastRotate));
        project.setAxes(this.createAxisList());
        project.getBuildersList().add((Object)this.createMockLoadBuilder(averageDuration));
        project.getPublishersList().add((Object)this.createArtifactArchiver());
        project.getPublishersList().add((Object)this.createFingerprinter());
        project.getPublishersList().add((Object)this.createJunitArchiver());
        project.setAssignedLabel(null);
        project.save();
    }

    @Override
    public String getName() {
        return "Matrix";
    }

    private MatrixProject createProject(ModifiableTopLevelItemGroup ig, String name) throws IOException {
        return (MatrixProject)ig.createProject((TopLevelItemDescriptor)Jenkins.get().getDescriptorByType(MatrixProject.DescriptorImpl.class), name, true);
    }

    private AxisList createAxisList() {
        return new AxisList(new Axis[]{new TextAxis("X", new String[]{"1", "2"}), new TextAxis("Y", new String[]{"1", "2"})});
    }
}

