/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.cli.CLICommand;
import hudson.model.Computer;
import hudson.model.Item;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugin.mockloadbuilder.Helper;
import jenkins.plugin.mockloadbuilder.MockProjectFactory;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class CreateMockLoadJobs
extends CLICommand {
    static final String NAME_PREFIX = "mock-load-job-";
    @Option(name="--fast-rotate", usage="Enable fast rotation of builds")
    public boolean fastRotate;
    @Argument(index=0, metaVar="COUNT", usage="Number of jobs to create", required=true)
    public Integer count;
    @Argument(index=1, metaVar="DURATION", usage="Average build duration, -1 will give a typical random duration to each job")
    public Long averageDuration;
    @Argument(index=2, metaVar="FOLDER", usage="Where to create the jobs")
    public String group;

    public String getShortDescription() {
        return "Creates a set of jobs that generate a mock load";
    }

    protected int run() throws Exception {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Item.CREATE);
        ModifiableTopLevelItemGroup ig = Helper.resolveFolder(this.group);
        ArrayList<MockProjectFactory> factories = new ArrayList<MockProjectFactory>(100);
        for (MockProjectFactory f : ExtensionList.lookup(MockProjectFactory.class)) {
            for (int i = 0; i < f.getFrequency(); ++i) {
                factories.add(f);
            }
        }
        Random entropy = new Random();
        Collections.shuffle(factories, entropy);
        if (this.averageDuration == null || this.averageDuration < 0L) {
            this.averageDuration = 60L;
        }
        long sumDuration = 0L;
        int countDuration = 0;
        int index = 0;
        double multiplier = 1.0;
        for (int n = 0; n < this.count; ++n) {
            String paddedIndex = StringUtils.leftPad((String)Integer.toString(n + 1), (int)5, (char)'0');
            String name = NAME_PREFIX + paddedIndex;
            if (ig.getItem(name) != null) continue;
            Jenkins.checkGoodName((String)name);
            index %= factories.size();
            MockProjectFactory factory = (MockProjectFactory)factories.get(index++);
            long duration = (long)((double)this.averageDuration.longValue() * Math.exp(entropy.nextGaussian()) / 1.649);
            factory.create(ig, name, duration, this.fastRotate);
            this.stdout.println("Created " + name + " (" + factory.getName() + ") with average duration " + duration + "s");
            sumDuration += duration * (long)factory.getMultiplier();
            countDuration += factory.getMultiplier();
            multiplier = (multiplier * (double)n + (double)factory.getMultiplier()) / ((double)n + 1.0);
        }
        if (countDuration > 0) {
            this.stdout.printf("Overall average duration: %ds%n", sumDuration / (long)countDuration);
        }
        this.stdout.printf("Expected executor multiplier: %.1f x (number of builds scheduled per minute)%n", (double)sumDuration / 60.0 / (double)countDuration * multiplier);
        int executorCount = 0;
        for (Computer c : jenkins.getComputers()) {
            executorCount += c.getNumExecutors();
        }
        this.stdout.printf("Current ideal max build rate: %.1f builds per minute%n", Math.floor((double)executorCount / ((double)sumDuration / 60.0 / (double)countDuration * multiplier)));
        return 0;
    }
}

