/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import hudson.ExtensionPoint;
import hudson.model.Descriptor;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.Fingerprinter;
import hudson.tasks.LogRotator;
import hudson.tasks.junit.JUnitResultArchiver;
import java.io.IOException;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugin.mockloadbuilder.MockLoadBuilder;

public abstract class MockProjectFactory
implements ExtensionPoint {
    static boolean mode = Boolean.getBoolean("fakeMockLoad");

    public abstract int getFrequency();

    public int getMultiplier() {
        return 1;
    }

    public abstract void create(ModifiableTopLevelItemGroup var1, String var2, Long var3, boolean var4) throws IOException, Descriptor.FormException;

    protected ArtifactArchiver createArtifactArchiver() {
        ArtifactArchiver artifactArc = new ArtifactArchiver("mock-artifact-*.txt");
        artifactArc.setAllowEmptyArchive(true);
        return artifactArc;
    }

    protected JUnitResultArchiver createJunitArchiver() {
        return new JUnitResultArchiver("mock-junit.xml");
    }

    protected Fingerprinter createFingerprinter() {
        return new Fingerprinter("mock-artifact-*.txt");
    }

    protected MockLoadBuilder createMockLoadBuilder(Long averageDuration) {
        return new MockLoadBuilder(averageDuration == null || averageDuration < 0L ? 60L : averageDuration);
    }

    protected LogRotator createBuildDiscarder(boolean fastRotate) {
        return fastRotate ? new LogRotator(-1, 5, -1, 1) : new LogRotator(30, 100, 10, 33);
    }

    public abstract String getName();
}

