/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import com.google.common.collect.ImmutableSet;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import jenkins.plugin.mockloadbuilder.Messages;
import jenkins.plugin.mockloadbuilder.MockLoadBuilder;
import jenkins.plugin.mockloadbuilder.MockProjectFactory;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class MockLoadStep
extends Step {
    private final long averageDuration;

    @DataBoundConstructor
    public MockLoadStep(long averageDuration) {
        this.averageDuration = averageDuration;
    }

    public long getAverageDuration() {
        return this.averageDuration;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient MockLoadStep step;

        Execution(MockLoadStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            if (MockProjectFactory.mode) {
                ws.act(ws.asCallableWith((FilePath.FileCallable)new MockLoadBuilder.NoFork(this.step.getAverageDuration(), listener)));
            } else {
                try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/mock/MockLoad.class");
                     OutputStream os = ws.child("mock/MockLoad.class").write();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                launcher.launch().pwd(ws).cmds(new String[]{"java", "mock.MockLoad", Long.toString(this.step.getAverageDuration())}).stdout(listener).start().join();
            }
            return null;
        }
    }

    @OptionalExtension(requirePlugins={"workflow-step-api"})
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(FilePath.class, Launcher.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "mockLoad";
        }

        public String getDisplayName() {
            return Messages.MockLoadBuilder_DisplayName();
        }
    }
}

