/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugin.mockloadbuilder.Messages;
import jenkins.plugin.mockloadbuilder.MockProjectFactory;
import jenkins.tasks.SimpleBuildStep;
import mock.MockLoad;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class MockLoadBuilder
extends Builder
implements SimpleBuildStep {
    private final long averageDuration;

    @DataBoundConstructor
    public MockLoadBuilder(long averageDuration) {
        this.averageDuration = averageDuration;
    }

    public long getAverageDuration() {
        return this.averageDuration;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (MockProjectFactory.mode) {
            workspace.act(workspace.asCallableWith((FilePath.FileCallable)new NoFork(this.averageDuration, listener)));
        } else {
            try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/mock/MockLoad.class");
                 OutputStream os = workspace.child("mock/MockLoad.class").write();){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            launcher.launch().pwd(workspace).cmds(new String[]{"java", "mock.MockLoad", Long.toString(this.averageDuration)}).stdout(listener).start().join();
        }
    }

    static class NoFork
    extends MasterToSlaveFileCallable<Boolean> {
        private final TaskListener listener;
        private long averageDuration;

        NoFork(long averageDuration, TaskListener listener) {
            this.listener = listener;
            this.averageDuration = averageDuration;
        }

        public Boolean invoke(File file, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            try {
                return MockLoad.build(file, this.averageDuration, this.listener.getLogger());
            }
            catch (InterruptedException e) {
                throw new IOException("Interrupted", e);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.MockLoadBuilder_DisplayName();
        }
    }
}

