/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugin.mockloadbuilder.Helper;
import org.kohsuke.args4j.Argument;

@Extension
public class ClearMockLoadJobs
extends CLICommand {
    @Argument(index=0, metaVar="FOLDER", usage="Where to create the jobs")
    public String group;

    public String getShortDescription() {
        return "Clear previously created mock jobs using create-mock-load-jobs";
    }

    protected int run() throws Exception {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Item.DELETE);
        ModifiableTopLevelItemGroup ig = Helper.resolveFolder(this.group);
        boolean error = false;
        int count = 0;
        this.stdout.println("Deleting mock jobs");
        for (TopLevelItem i : ig.getItems()) {
            String name = i.getName();
            try {
                if (!name.startsWith("mock-load-job-")) continue;
                i.delete();
                ++count;
            }
            catch (IOException e) {
                this.stderr.println("Failed to delete " + name);
                error = true;
            }
        }
        this.stdout.println("Deleted " + count + " jobs.");
        if (error) {
            this.stderr.println("Failed to delete some jobs.");
        }
        return error ? 1 : 0;
    }
}

