/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import hudson.Extension;
import hudson.FilePath;
import hudson.slaves.WorkspaceList;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class WithMockLoadStep
extends Step {
    @DataBoundSetter
    public long averageDuration = 60L;
    @DataBoundSetter
    public boolean testFailureIgnore;

    @DataBoundConstructor
    public WithMockLoadStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this.averageDuration, this.testFailureIgnore);
    }

    private static final class Execution
    extends GeneralNonBlockingStepExecution {
        private final long averageDuration;
        private final boolean testFailureIgnore;
        private String classpathDirPath;

        Execution(StepContext context, long averageDuration, boolean testFailureIgnore) {
            super(context);
            this.averageDuration = averageDuration;
            this.testFailureIgnore = testFailureIgnore;
        }

        public boolean start() throws Exception {
            this.run(() -> {
                FilePath tempDir = WorkspaceList.tempDir((FilePath)((FilePath)this.getContext().get(FilePath.class)));
                if (tempDir == null) {
                    throw new IOException("could not create temp dir");
                }
                tempDir.mkdirs();
                FilePath classpathDir = tempDir.createTempDir("mock-cp", null);
                this.classpathDirPath = classpathDir.getRemote();
                classpathDir.child("mock/MockLoad.class").copyFrom(WithMockLoadStep.class.getResource("/mock/MockLoad.class"));
                String command = "java " + (this.testFailureIgnore ? "-Dmaven.test.failure.ignore=true " : "") + "-classpath \"" + this.classpathDirPath + "\" mock.MockLoad " + this.averageDuration;
                this.getContext().newBodyInvoker().withContexts(new Object[]{EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)EnvironmentExpander.constant(Map.of("MOCK_LOAD_COMMAND", command)))}).withCallback((BodyExecutionCallback)new CleanUp()).start();
            });
            return false;
        }

        private class CleanUp
        extends BodyExecutionCallback.TailCall {
            private CleanUp() {
            }

            protected void finished(StepContext context) throws Exception {
                Execution.this.run(() -> ((FilePath)context.get(FilePath.class)).child(Execution.this.classpathDirPath).deleteRecursive());
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(FilePath.class);
        }

        public String getFunctionName() {
            return "withMockLoad";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public String getDisplayName() {
            return "Mock load with separate sh command";
        }
    }
}

