/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import hudson.Extension;
import hudson.model.FreeStyleProject;
import hudson.model.TopLevelItemDescriptor;
import java.io.IOException;
import jenkins.model.BuildDiscarder;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugin.mockloadbuilder.Config;
import jenkins.plugin.mockloadbuilder.MockProjectFactory;

@Extension
public class FreeStyleMockProjectFactory
extends MockProjectFactory {
    @Override
    public int getFrequency() {
        return Config.get().getFreestyleFrequency();
    }

    @Override
    public void create(ModifiableTopLevelItemGroup ig, String name, Long averageDuration, boolean fastRotate) throws IOException {
        FreeStyleProject project = this.createProject(ig, name);
        project.setBuildDiscarder((BuildDiscarder)this.createBuildDiscarder(fastRotate));
        project.getBuildersList().add((Object)this.createMockLoadBuilder(averageDuration));
        project.getPublishersList().add((Object)this.createArtifactArchiver());
        project.getPublishersList().add((Object)this.createFingerprinter());
        project.getPublishersList().add((Object)this.createJunitArchiver());
        project.setAssignedLabel(null);
        project.save();
    }

    @Override
    public String getName() {
        return "Freestyle";
    }

    private FreeStyleProject createProject(ModifiableTopLevelItemGroup ig, String name) throws IOException {
        return (FreeStyleProject)ig.createProject((TopLevelItemDescriptor)Jenkins.get().getDescriptorByType(FreeStyleProject.DescriptorImpl.class), name, true);
    }
}

