/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugin.mockloadbuilder;

import hudson.ExtensionList;
import hudson.cli.CLICommand;
import hudson.model.Item;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.plugin.mockloadbuilder.MockProjectFactory;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public abstract class AbstractCreateMockLoad
extends CLICommand {
    @Option(name="--fast-rotate", usage="Enable fast rotation of builds")
    public boolean fastRotate;
    @Argument(index=0, metaVar="NAME", usage="Name of the job to create", required=true)
    public String name;
    @Argument(index=1, metaVar="DURATION", usage="Average build duration (seconds)")
    public Long averageDuration;

    protected final int run() throws Exception {
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Item.CREATE);
        MockProjectFactory factory = (MockProjectFactory)ExtensionList.lookupSingleton(this.getProjectFactoryClass());
        if (jenkins.getItemByFullName(this.name) != null) {
            this.stderr.println("Job '" + this.name + "' already exists");
            return -1;
        }
        Jenkins ig = jenkins;
        int i = this.name.lastIndexOf(47);
        if (i > 0) {
            String group = this.name.substring(0, i);
            Item item = jenkins.getItemByFullName(group);
            if (item == null) {
                throw new IllegalArgumentException("Unknown ItemGroup " + group);
            }
            if (!(item instanceof ModifiableTopLevelItemGroup)) {
                throw new IllegalArgumentException("Can't create job from CLI in " + group);
            }
            ig = (ModifiableTopLevelItemGroup)item;
            this.name = this.name.substring(i + 1);
        }
        Jenkins.checkGoodName((String)this.name);
        factory.create((ModifiableTopLevelItemGroup)ig, this.name, this.averageDuration, this.fastRotate);
        return 0;
    }

    protected abstract Class<? extends MockProjectFactory> getProjectFactoryClass();
}

