/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jenkins.metrics.api.Metrics;

public class MetricsFilter
implements Filter {
    private static final String NAME_PREFIX = "responseCodes.";
    private static final int OK = 200;
    private static final int CREATED = 201;
    private static final int NO_CONTENT = 204;
    private static final int NOT_MODIFIED = 304;
    private static final int BAD_REQUEST = 400;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int SERVER_ERROR = 500;
    private static final int SERVICE_UNAVAILABLE = 503;
    private final String otherMetricName;
    private final Map<Integer, String> meterNamesByStatusCode = MetricsFilter.createMeterNamesByStatusCode();
    private ConcurrentMap<Integer, Meter> metersByStatusCode;
    private Meter otherMeter;
    private Counter activeRequests;
    private Timer requestTimer;

    public MetricsFilter() {
        this.otherMetricName = "responseCodes.other";
    }

    private static Map<Integer, String> createMeterNamesByStatusCode() {
        HashMap<Integer, String> meterNamesByStatusCode = new HashMap<Integer, String>(6);
        meterNamesByStatusCode.put(200, "responseCodes.ok");
        meterNamesByStatusCode.put(201, "responseCodes.created");
        meterNamesByStatusCode.put(304, "responseCodes.notModified");
        meterNamesByStatusCode.put(204, "responseCodes.noContent");
        meterNamesByStatusCode.put(400, "responseCodes.badRequest");
        meterNamesByStatusCode.put(403, "responseCodes.forbidden");
        meterNamesByStatusCode.put(404, "responseCodes.notFound");
        meterNamesByStatusCode.put(500, "responseCodes.serverError");
        meterNamesByStatusCode.put(503, "responseCodes.serviceUnavailable");
        return meterNamesByStatusCode;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        MetricRegistry metricsRegistry = Metrics.metricRegistry();
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(this.meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : this.meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), metricsRegistry.meter(MetricRegistry.name((String)"http", (String[])new String[]{entry.getValue()})));
        }
        this.otherMeter = metricsRegistry.meter(MetricRegistry.name((String)"http", (String[])new String[]{this.otherMetricName}));
        this.activeRequests = metricsRegistry.counter(MetricRegistry.name((String)"http", (String[])new String[]{"activeRequests"}));
        this.requestTimer = metricsRegistry.timer(MetricRegistry.name((String)"http", (String[])new String[]{"requests"}));
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response);
        this.activeRequests.inc();
        Timer.Context context = this.requestTimer.time();
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        finally {
            context.stop();
            this.activeRequests.dec();
            this.markMeterForStatusCode(wrappedResponse.getStatus());
        }
    }

    private void markMeterForStatusCode(int status) {
        Meter metric = (Meter)this.metersByStatusCode.get(status);
        if (metric != null) {
            metric.mark();
        } else {
            this.otherMeter.mark();
        }
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus = 200;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public int getStatus() {
            return this.httpStatus;
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }
    }
}

