/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.impl;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowReservoir;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.sun.management.OperatingSystemMXBean;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.metrics.api.MetricProvider;
import jenkins.metrics.util.AutoSamplingHistogram;

@Extension
public class VMMetricProviderImpl
extends MetricProvider {
    private static final Logger LOG = Logger.getLogger(VMMetricProviderImpl.class.getName());
    private final MetricSet set;
    private final Gauge<Double> systemCpuLoad;
    private final Gauge<Double> vmCpuLoad;

    public VMMetricProviderImpl() {
        CpuUsageGauge cpuUsage;
        Gauge<Double> systemLoad = new Gauge<Double>(){

            public Double getValue() {
                java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
                return operatingSystemMXBean.getSystemLoadAverage();
            }
        };
        try {
            cpuUsage = new CpuUsageGauge(1, TimeUnit.SECONDS);
        }
        catch (IllegalStateException e) {
            LOG.log(Level.WARNING, "Will not be able to provide CPU load", e);
            cpuUsage = null;
        }
        this.systemCpuLoad = (Double)systemLoad.getValue() >= 0.0 ? systemLoad : null;
        this.vmCpuLoad = cpuUsage;
        TreeMap<String, Metric> memoryMetrics = new TreeMap<String, Metric>();
        for (Map.Entry entry : new MemoryUsageGaugeSet().getMetrics().entrySet()) {
            Gauge gauge;
            String key = (String)entry.getKey();
            Metric value = (Metric)entry.getValue();
            memoryMetrics.put(key, value);
            if ((key.endsWith(".used") || key.endsWith(".committed")) && value instanceof Gauge) {
                gauge = (Gauge)value;
                memoryMetrics.put(MetricRegistry.name((String)key, (String[])new String[]{"history"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)gauge));
                memoryMetrics.put(MetricRegistry.name((String)key, (String[])new String[]{"window", "5m"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)gauge, (Reservoir)new SlidingTimeWindowReservoir(5L, TimeUnit.MINUTES)));
                memoryMetrics.put(MetricRegistry.name((String)key, (String[])new String[]{"window", "15m"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)gauge, (Reservoir)new SlidingTimeWindowReservoir(15L, TimeUnit.MINUTES)));
                memoryMetrics.put(MetricRegistry.name((String)key, (String[])new String[]{"window", "1h"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)gauge, (Reservoir)new SlidingTimeWindowReservoir(1L, TimeUnit.HOURS)));
                continue;
            }
            if (!key.endsWith(".usage") || !(value instanceof Gauge)) continue;
            gauge = new DoubleToLongGauge((Gauge<Double>)((Gauge)value), 100.0);
            memoryMetrics.put(MetricRegistry.name((String)key, (String[])new String[]{"x100", "history"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)gauge));
            memoryMetrics.put(MetricRegistry.name((String)key, (String[])new String[]{"x100", "window", "5m"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)gauge, (Reservoir)new SlidingTimeWindowReservoir(5L, TimeUnit.MINUTES)));
            memoryMetrics.put(MetricRegistry.name((String)key, (String[])new String[]{"x100", "window", "15m"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)gauge, (Reservoir)new SlidingTimeWindowReservoir(15L, TimeUnit.MINUTES)));
            memoryMetrics.put(MetricRegistry.name((String)key, (String[])new String[]{"x100", "window", "1h"}), (Metric)new AutoSamplingHistogram((Gauge<? extends Number>)gauge, (Reservoir)new SlidingTimeWindowReservoir(1L, TimeUnit.HOURS)));
        }
        FileDescriptorRatioGauge fileDescriptors = new FileDescriptorRatioGauge();
        DoubleToLongGauge fileDescriptorsPercent = new DoubleToLongGauge((Gauge<Double>)fileDescriptors, 100.0);
        this.set = VMMetricProviderImpl.metrics(VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"memory"}), (Metric)VMMetricProviderImpl.metrics(memoryMetrics)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"gc"}), (Metric)new GarbageCollectorMetricSet()), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"file.descriptor.ratio"}), (Metric)fileDescriptors), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"file.descriptor.ratio.x100", "history"}), (Metric)new AutoSamplingHistogram(fileDescriptorsPercent)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"file.descriptor.ratio.x100", "window", "5m"}), (Metric)new AutoSamplingHistogram(fileDescriptorsPercent, (Reservoir)new SlidingTimeWindowReservoir(5L, TimeUnit.MINUTES))), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"file.descriptor.ratio.x100", "window", "15m"}), (Metric)new AutoSamplingHistogram(fileDescriptorsPercent, (Reservoir)new SlidingTimeWindowReservoir(15L, TimeUnit.MINUTES))), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"file.descriptor.ratio.x100", "window", "1h"}), (Metric)new AutoSamplingHistogram(fileDescriptorsPercent, (Reservoir)new SlidingTimeWindowReservoir(1L, TimeUnit.HOURS))), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[0]), (Metric)new ThreadStatesGaugeSet()), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"uptime", "milliseconds"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return ManagementFactory.getRuntimeMXBean().getUptime();
            }
        }), VMMetricProviderImpl.metric(MetricRegistry.name((String)"system", (String[])new String[]{"cpu", "load"}), this.systemCpuLoad), VMMetricProviderImpl.metric(MetricRegistry.name((String)"system", (String[])new String[]{"cpu", "load", "x100", "history"}), (Metric)(this.systemCpuLoad != null ? new AutoSamplingHistogram(new DoubleToLongGauge(this.systemCpuLoad, 100.0)) : null)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"system", (String[])new String[]{"cpu", "load", "x100", "window", "5m"}), (Metric)(this.systemCpuLoad != null ? new AutoSamplingHistogram(new DoubleToLongGauge(this.systemCpuLoad, 100.0), (Reservoir)new SlidingTimeWindowReservoir(5L, TimeUnit.MINUTES)) : null)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"system", (String[])new String[]{"cpu", "load", "x100", "window", "15m"}), (Metric)(this.systemCpuLoad != null ? new AutoSamplingHistogram(new DoubleToLongGauge(this.systemCpuLoad, 100.0), (Reservoir)new SlidingTimeWindowReservoir(15L, TimeUnit.MINUTES)) : null)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"system", (String[])new String[]{"cpu", "load", "x100", "window", "1h"}), (Metric)(this.systemCpuLoad != null ? new AutoSamplingHistogram(new DoubleToLongGauge(this.systemCpuLoad, 100.0), (Reservoir)new SlidingTimeWindowReservoir(1L, TimeUnit.HOURS)) : null)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"cpu", "load"}), this.vmCpuLoad), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"cpu", "load", "x100", "history"}), (Metric)(this.vmCpuLoad != null ? new AutoSamplingHistogram(new DoubleToLongGauge(this.vmCpuLoad, 100.0)) : null)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"cpu", "load", "x100", "window", "5m"}), (Metric)(this.vmCpuLoad != null ? new AutoSamplingHistogram(new DoubleToLongGauge(this.vmCpuLoad, 100.0), (Reservoir)new SlidingTimeWindowReservoir(5L, TimeUnit.MINUTES)) : null)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"cpu", "load", "x100", "window", "15m"}), (Metric)(this.vmCpuLoad != null ? new AutoSamplingHistogram(new DoubleToLongGauge(this.vmCpuLoad, 100.0), (Reservoir)new SlidingTimeWindowReservoir(15L, TimeUnit.MINUTES)) : null)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"cpu", "load", "x100", "window", "1h"}), (Metric)(this.vmCpuLoad != null ? new AutoSamplingHistogram(new DoubleToLongGauge(this.vmCpuLoad, 100.0), (Reservoir)new SlidingTimeWindowReservoir(1L, TimeUnit.HOURS)) : null)), VMMetricProviderImpl.metric(MetricRegistry.name((String)"vm", (String[])new String[]{"class"}), (Metric)new ClassLoadingGaugeSet()));
    }

    @CheckForNull
    public Gauge<Double> getSystemCpuLoad() {
        return this.systemCpuLoad;
    }

    @CheckForNull
    public Gauge<Double> getVmCpuLoad() {
        return this.vmCpuLoad;
    }

    @Override
    @NonNull
    public MetricSet getMetricSet() {
        return this.set;
    }

    private static class CpuUsageGauge
    extends CachedGauge<Double> {
        private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        private final OperatingSystemMXBean operatingSystemMXBean;
        long prevUptime;
        long prevCpu;

        public CpuUsageGauge(int timeout, TimeUnit timeUnit) {
            super((long)timeout, timeUnit);
            if (!(ManagementFactory.getOperatingSystemMXBean() instanceof OperatingSystemMXBean)) {
                throw new IllegalStateException("Not using com.sun.management.OperatingSystemMXBean");
            }
            this.operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        }

        protected synchronized Double loadValue() {
            long uptime = this.runtimeMXBean.getUptime();
            long cpu = this.operatingSystemMXBean.getProcessCpuTime();
            long elapsedTime = uptime - this.prevUptime;
            double elapsedCpu = TimeUnit.NANOSECONDS.toMillis(cpu - this.prevCpu);
            this.prevUptime = uptime;
            this.prevCpu = cpu;
            return Math.min(99.0, elapsedCpu / (double)elapsedTime);
        }
    }

    private static class DoubleToLongGauge
    implements Gauge<Long> {
        private final Gauge<Double> delegate;
        private final double scaleFactor;

        private DoubleToLongGauge(Gauge<Double> delegate, double scaleFactor) {
            this.delegate = delegate;
            this.scaleFactor = scaleFactor;
        }

        public Long getValue() {
            return Math.round((Double)this.delegate.getValue() * this.scaleFactor);
        }
    }
}

