/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Run;
import java.io.Serializable;
import java.util.List;
import jenkins.metrics.impl.SubTaskTimeInQueueAction;
import jenkins.model.RunAction2;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class TimeInQueueAction
implements Serializable,
RunAction2 {
    private static final long serialVersionUID = 1L;
    private final long queuingDurationMillis;
    private final long blockedDurationMillis;
    private final long buildableDurationMillis;
    private final long waitingDurationMillis;
    @CheckForNull
    private transient Run<?, ?> run;

    @Restricted(value={DoNotUse.class})
    @Deprecated
    public TimeInQueueAction(long queuingDurationMillis) {
        this(queuingDurationMillis, 0L, 0L, 0L);
    }

    public TimeInQueueAction(long millisecondsInQueue, long blockedDurationMillis, long buildableDurationMillis, long waitingDurationMillis) {
        this.queuingDurationMillis = millisecondsInQueue;
        this.blockedDurationMillis = blockedDurationMillis;
        this.buildableDurationMillis = buildableDurationMillis;
        this.waitingDurationMillis = waitingDurationMillis;
    }

    @Exported(visibility=1)
    public long getQueuingDurationMillis() {
        return this.queuingDurationMillis;
    }

    @Exported(visibility=2)
    public long getBlockedDurationMillis() {
        return this.blockedDurationMillis;
    }

    @Exported(visibility=2)
    public long getBuildableDurationMillis() {
        return this.buildableDurationMillis;
    }

    @Exported(visibility=2)
    public long getWaitingDurationMillis() {
        return this.waitingDurationMillis;
    }

    public boolean isHasSubTasks() {
        return this.run != null && this.run.getAction(SubTaskTimeInQueueAction.class) != null;
    }

    @Exported(visibility=1)
    public long getQueuingTimeMillis() {
        if (this.run == null) {
            return this.queuingDurationMillis;
        }
        long total = this.queuingDurationMillis;
        for (SubTaskTimeInQueueAction t : this.run.getActions(SubTaskTimeInQueueAction.class)) {
            total += t.getQueuingDurationMillis();
        }
        return total;
    }

    @Exported(visibility=2)
    public long getBlockedTimeMillis() {
        if (this.run == null) {
            return this.blockedDurationMillis;
        }
        long total = this.blockedDurationMillis;
        for (SubTaskTimeInQueueAction t : this.run.getActions(SubTaskTimeInQueueAction.class)) {
            total += t.getBlockedDurationMillis();
        }
        return total;
    }

    @Exported(visibility=2)
    public long getBuildableTimeMillis() {
        if (this.run == null) {
            return this.buildableDurationMillis;
        }
        long total = this.buildableDurationMillis;
        for (SubTaskTimeInQueueAction t : this.run.getActions(SubTaskTimeInQueueAction.class)) {
            total += t.getBuildableDurationMillis();
        }
        return total;
    }

    @Exported(visibility=2)
    public long getWaitingTimeMillis() {
        if (this.run == null) {
            return this.waitingDurationMillis;
        }
        long total = this.waitingDurationMillis;
        for (SubTaskTimeInQueueAction t : this.run.getActions(SubTaskTimeInQueueAction.class)) {
            total += t.getWaitingDurationMillis();
        }
        return total;
    }

    @Exported(visibility=2)
    public long getExecutingTimeMillis() {
        if (this.run == null) {
            return 0L;
        }
        List actions = this.run.getActions(SubTaskTimeInQueueAction.class);
        if (actions.isEmpty()) {
            return this.run.getDuration();
        }
        long total = 0L;
        for (SubTaskTimeInQueueAction t : actions) {
            total += t.getExecutingDurationMillis() * (long)t.getWorkUnitCount();
        }
        return total;
    }

    @Exported(visibility=2)
    public long getBuildingDurationMillis() {
        return this.run == null ? 0L : this.run.getDuration();
    }

    @Exported(visibility=1)
    public long getTotalDurationMillis() {
        return this.queuingDurationMillis + this.getBuildingDurationMillis();
    }

    @Exported(visibility=2)
    public double getExecutorUtilization() {
        long buildingDurationMillis = this.getBuildingDurationMillis();
        return buildingDurationMillis > 0L ? (double)Math.round((double)this.getExecutingTimeMillis() * 100.0 / (double)buildingDurationMillis) / 100.0 : 1.0;
    }

    @Exported(visibility=2)
    public int getSubTaskCount() {
        if (this.run == null) {
            return 0;
        }
        return this.run.getActions(SubTaskTimeInQueueAction.class).size();
    }

    @Restricted(value={DoNotUse.class})
    public Run getRun() {
        return this.run;
    }

    @Restricted(value={DoNotUse.class})
    public String getQueuingDurationString() {
        return Util.getTimeSpanString((long)this.getQueuingDurationMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getQueuingTimeString() {
        return Util.getTimeSpanString((long)this.getQueuingTimeMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getBlockedTimeString() {
        return Util.getTimeSpanString((long)this.getBlockedTimeMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getBuildableTimeString() {
        return Util.getTimeSpanString((long)this.getBuildableTimeMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getWaitingTimeString() {
        return Util.getTimeSpanString((long)this.getWaitingTimeMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getBlockedDurationString() {
        return Util.getTimeSpanString((long)this.getBlockedDurationMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getBuildableDurationString() {
        return Util.getTimeSpanString((long)this.getBuildableDurationMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getWaitingDurationString() {
        return Util.getTimeSpanString((long)this.getWaitingDurationMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getExecutingTimeString() {
        return Util.getTimeSpanString((long)this.getExecutingTimeMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getBuildingDurationString() {
        return Util.getTimeSpanString((long)this.getBuildingDurationMillis());
    }

    @Restricted(value={DoNotUse.class})
    public String getTotalDurationString() {
        return Util.getTimeSpanString((long)this.getTotalDurationMillis());
    }

    public String getIconFileName() {
        return "symbol-stopwatch-outline plugin-ionicons-api";
    }

    public String getDisplayName() {
        return "Timings";
    }

    public String getUrlName() {
        return "timings";
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }
}

