/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.api;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.json.HealthCheckModule;
import com.codahale.metrics.json.MetricsModule;
import com.codahale.metrics.jvm.ThreadDump;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.PeriodicWork;
import hudson.model.UnprotectedRootAction;
import hudson.util.HttpResponses;
import hudson.util.VersionNumber;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jenkins.metrics.api.Metrics;
import jenkins.metrics.util.ExponentialLeakyBucket;
import jenkins.metrics.util.NameRewriterMetricRegistry;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class MetricsRootAction
implements UnprotectedRootAction {
    public static final TimeUnit RATE_UNIT = TimeUnit.MINUTES;
    public static final TimeUnit DURATION_UNIT = TimeUnit.SECONDS;
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final Pattern CACHE_CONTROL_MAX_AGE = Pattern.compile("[\\s,]?max-age=(\\d+)[\\s,]?");
    private static final String NO_CACHE = "must-revalidate,no-cache,no-store";
    private static final String MAX_AGE = "must-revalidate,private,max-age=%d";
    private static final String PLAIN_TEXT_CONTENT_TYPE = "text/plain";
    private static final String JSONP_CONTENT_TYPE = "text/javascript";
    private static final String JSON_CONTENT_TYPE = "application/json";
    private final Pseudoservlet currentUser = new CurrentUserPseudoservlet();
    private final ObjectMapper healthCheckMapper = new ObjectMapper().registerModule((Module)new HealthCheckModule());
    private final ObjectMapper metricsMapper = new ObjectMapper().registerModule((Module)new MetricsModule(RATE_UNIT, DURATION_UNIT, true));

    private static boolean isAllHealthy(Map<String, HealthCheck.Result> results) {
        for (HealthCheck.Result result : results.values()) {
            if (result.isHealthy()) continue;
            return false;
        }
        return true;
    }

    private static ObjectWriter getWriter(ObjectMapper mapper, HttpServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return mapper.writerWithDefaultPrettyPrinter();
        }
        return mapper.writer();
    }

    private static void requireCorrectMethod(@NonNull StaplerRequest2 req) throws IllegalAccessException {
        if (!(req.getMethod().equals("POST") || req.getMethod().equals("OPTIONS") && StringUtils.isNotBlank((CharSequence)req.getHeader("Origin")) || req.getMethod().equals("GET") && MetricsRootAction.getKeyFromAuthorizationHeader(req) != null)) {
            throw new IllegalAccessException("POST is required");
        }
    }

    @CheckForNull
    private static String getKeyFromAuthorizationHeader(@NonNull StaplerRequest2 req) {
        for (Object o : Collections.list(req.getHeaders("Authorization"))) {
            if (!(o instanceof String) || !((String)o).startsWith("Jenkins-Metrics-Key ")) continue;
            return Util.fixEmptyAndTrim((String)((String)o).substring("Jenkins-Metrics-Key ".length()));
        }
        return null;
    }

    private static long getCacheControlMaxAge(StaplerRequest2 req) {
        long maxAge = -1L;
        for (String value : Collections.list(req.getHeaders(CACHE_CONTROL))) {
            Matcher matcher = CACHE_CONTROL_MAX_AGE.matcher(value);
            while (matcher.find()) {
                maxAge = TimeUnit.SECONDS.toMillis(Long.parseLong(matcher.group(1)));
            }
        }
        return Math.max(-1L, maxAge);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "metrics";
    }

    @Restricted(value={NoExternalUse.class})
    public Object getDynamic(String key) {
        Metrics.checkAccessKey(key);
        return new AccessKeyPseudoservlet(key);
    }

    @Restricted(value={NoExternalUse.class})
    public Object getCurrentUser() {
        Jenkins.getInstance().checkPermission(Metrics.VIEW);
        return this.currentUser;
    }

    @Restricted(value={NoExternalUse.class})
    public HttpResponse doHealthcheck(StaplerRequest2 req, @QueryParameter(value="key") String key) throws IllegalAccessException {
        MetricsRootAction.requireCorrectMethod(req);
        if (StringUtils.isBlank((CharSequence)key)) {
            key = MetricsRootAction.getKeyFromAuthorizationHeader(req);
        }
        Metrics.checkAccessKeyHealthCheck(key);
        long ifModifiedSince = req.getDateHeader("If-Modified-Since");
        long maxAge = MetricsRootAction.getCacheControlMaxAge(req);
        Metrics.HealthCheckData data = Metrics.getHealthCheckData();
        if (data == null || maxAge != -1L && data.getLastModified() + maxAge < System.currentTimeMillis()) {
            data = new Metrics.HealthCheckData(Metrics.healthCheckRegistry().runHealthChecks());
        } else if (ifModifiedSince != -1L && data.getLastModified() < ifModifiedSince) {
            return Metrics.cors(key, (HttpResponse)HttpResponses.status((int)304));
        }
        return Metrics.cors(key, new HealthCheckResponse(data));
    }

    @Restricted(value={NoExternalUse.class})
    public HttpResponse doHealthcheckOk(StaplerRequest2 req) {
        long ifModifiedSince = req.getDateHeader("If-Modified-Since");
        long maxAge = MetricsRootAction.getCacheControlMaxAge(req);
        Metrics.HealthCheckData data = Metrics.getHealthCheckData();
        if (data == null || maxAge != -1L && data.getLastModified() + maxAge < System.currentTimeMillis()) {
            data = new Metrics.HealthCheckData(Metrics.healthCheckRegistry().runHealthChecks());
        } else if (ifModifiedSince != -1L && data.getLastModified() < ifModifiedSince) {
            return HttpResponses.status((int)304);
        }
        for (HealthCheck.Result result : data.getResults().values()) {
            if (result.isHealthy()) continue;
            return new StatusResponse(503, data.getLastModified(), data.getExpires());
        }
        return new StatusResponse(200, data.getLastModified(), data.getExpires());
    }

    @Restricted(value={NoExternalUse.class})
    public HttpResponse doMetrics(StaplerRequest2 req, @QueryParameter(value="key") String key) throws IllegalAccessException {
        MetricsRootAction.requireCorrectMethod(req);
        if (StringUtils.isBlank((CharSequence)key)) {
            key = MetricsRootAction.getKeyFromAuthorizationHeader(req);
        }
        Metrics.checkAccessKeyMetrics(key);
        return Metrics.cors(key, new MetricsResponse(Metrics.metricRegistry()));
    }

    @Restricted(value={NoExternalUse.class})
    public HttpResponse doMetricsHistory(StaplerRequest2 req, @QueryParameter(value="key") String key) throws IllegalAccessException {
        if (!Sampler.isEnabled()) {
            return HttpResponses.notFound();
        }
        MetricsRootAction.requireCorrectMethod(req);
        if (StringUtils.isBlank((CharSequence)key)) {
            key = MetricsRootAction.getKeyFromAuthorizationHeader(req);
        }
        Metrics.checkAccessKeyMetrics(key);
        return Metrics.cors(key, new MetricsHistoryResponse());
    }

    @Restricted(value={NoExternalUse.class})
    public HttpResponse doPing(StaplerRequest2 req, @QueryParameter(value="key") String key) throws IllegalAccessException {
        MetricsRootAction.requireCorrectMethod(req);
        if (StringUtils.isBlank((CharSequence)key)) {
            key = MetricsRootAction.getKeyFromAuthorizationHeader(req);
        }
        Metrics.checkAccessKeyPing(key);
        return Metrics.cors(key, new PingResponse());
    }

    @Restricted(value={NoExternalUse.class})
    @RequirePOST
    public HttpResponse doThreads(StaplerRequest2 req, @QueryParameter(value="key") String key) throws IllegalAccessException {
        MetricsRootAction.requireCorrectMethod(req);
        if (StringUtils.isBlank((CharSequence)key)) {
            key = MetricsRootAction.getKeyFromAuthorizationHeader(req);
        }
        Metrics.checkAccessKeyThreadDump(key);
        return Metrics.cors(key, new ThreadDumpResponse(new ThreadDump(ManagementFactory.getThreadMXBean())));
    }

    @Restricted(value={NoExternalUse.class})
    public class CurrentUserPseudoservlet
    extends Pseudoservlet {
        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doHealthcheck(StaplerRequest2 req) {
            Jenkins.getInstance().checkPermission(Metrics.HEALTH_CHECK);
            return super.doHealthcheck(req);
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doIndex() {
            Jenkins.getInstance().checkPermission(Metrics.VIEW);
            return super.doIndex();
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doMetrics() {
            Jenkins.getInstance().checkPermission(Metrics.VIEW);
            return super.doMetrics();
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doMetricsHistory() {
            Jenkins.getInstance().checkPermission(Metrics.VIEW);
            return super.doMetricsHistory();
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doPing() {
            Jenkins.getInstance().checkPermission(Metrics.VIEW);
            return super.doPing();
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doThreads() {
            Jenkins.getInstance().checkPermission(Metrics.THREAD_DUMP);
            return super.doThreads();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public class Pseudoservlet {
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doHealthcheck(StaplerRequest2 req) {
            long ifModifiedSince = req.getDateHeader("If-Modified-Since");
            long maxAge = MetricsRootAction.getCacheControlMaxAge(req);
            Metrics.HealthCheckData data = Metrics.getHealthCheckData();
            if (data == null || maxAge != -1L && data.getLastModified() + maxAge < System.currentTimeMillis()) {
                data = new Metrics.HealthCheckData(Metrics.healthCheckRegistry().runHealthChecks());
            } else if (ifModifiedSince != -1L && data.getLastModified() < ifModifiedSince) {
                return HttpResponses.status((int)304);
            }
            return new HealthCheckResponse(data);
        }

        @Restricted(value={NoExternalUse.class})
        public HttpResponse doMetrics() {
            return new MetricsResponse(Metrics.metricRegistry());
        }

        @Restricted(value={NoExternalUse.class})
        public HttpResponse doMetricsHistory() {
            if (!Sampler.isEnabled()) {
                return HttpResponses.notFound();
            }
            return new MetricsHistoryResponse();
        }

        @Restricted(value={NoExternalUse.class})
        public HttpResponse doPing() {
            return new PingResponse();
        }

        @Restricted(value={NoExternalUse.class})
        public HttpResponse doThreads() {
            return new ThreadDumpResponse(new ThreadDump(ManagementFactory.getThreadMXBean()));
        }

        @Restricted(value={NoExternalUse.class})
        public HttpResponse doIndex() {
            return HttpResponses.html((String)"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n        \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n  <title>Metrics</title>\n</head>\n<body>\n  <h1>Operational Menu</h1>\n  <ul>\n    <li><a href=\"./metrics?pretty=true\">Metrics</a></li>\n    <li><a href=\"./ping\">Ping</a></li>\n    <li><a href=\"./threads\">Threads</a></li>\n    <li><a href=\"./healthcheck?pretty=true\">Healthcheck</a></li>\n  </ul>\n</body>\n</html>");
        }
    }

    @Restricted(value={NoExternalUse.class})
    public class AccessKeyPseudoservlet
    extends Pseudoservlet {
        private final String key;

        public AccessKeyPseudoservlet(String key) {
            this.key = key;
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doHealthcheck(StaplerRequest2 req) {
            Metrics.checkAccessKeyHealthCheck(this.key);
            return Metrics.cors(this.key, super.doHealthcheck(req));
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doMetrics() {
            Metrics.checkAccessKeyMetrics(this.key);
            return Metrics.cors(this.key, super.doMetrics());
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doMetricsHistory() {
            Metrics.checkAccessKeyMetrics(this.key);
            return Metrics.cors(this.key, super.doMetricsHistory());
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doPing() {
            Metrics.checkAccessKeyPing(this.key);
            return Metrics.cors(this.key, super.doPing());
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public HttpResponse doThreads() {
            Metrics.checkAccessKeyThreadDump(this.key);
            return Metrics.cors(this.key, super.doThreads());
        }
    }

    private class HealthCheckResponse
    implements HttpResponse {
        @NonNull
        private final Metrics.HealthCheckData data;

        public HealthCheckResponse(Metrics.HealthCheckData data) {
            this.data = data;
        }

        public void generateResponse(StaplerRequest2 req, StaplerResponse2 resp, Object node) throws IOException, ServletException {
            boolean jsonp = StringUtils.isNotBlank((CharSequence)req.getParameter("callback"));
            String jsonpCallback = (String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("callback"), (CharSequence)"callback");
            resp.setContentType(jsonp ? MetricsRootAction.JSONP_CONTENT_TYPE : MetricsRootAction.JSON_CONTENT_TYPE);
            Long expires = this.data.getExpires();
            if (expires == null) {
                resp.setHeader(MetricsRootAction.CACHE_CONTROL, MetricsRootAction.NO_CACHE);
            } else {
                resp.setHeader(MetricsRootAction.CACHE_CONTROL, String.format(MetricsRootAction.MAX_AGE, TimeUnit.MILLISECONDS.toSeconds(expires - System.currentTimeMillis())));
                resp.setDateHeader("Expires", expires.longValue());
            }
            resp.setDateHeader("Last-Modified", this.data.getLastModified());
            SortedMap<String, HealthCheck.Result> results = this.data.getResults();
            if (results.isEmpty()) {
                resp.setStatus(501);
            } else if (MetricsRootAction.isAllHealthy(results)) {
                resp.setStatus(200);
            } else {
                resp.setStatus(500);
            }
            try (ServletOutputStream output = resp.getOutputStream();){
                if (jsonp) {
                    output.write(jsonpCallback.getBytes("US-ASCII"));
                    output.write("(".getBytes("US-ASCII"));
                }
                output.write(MetricsRootAction.getWriter(MetricsRootAction.this.healthCheckMapper, (HttpServletRequest)req).writeValueAsBytes(results));
                if (jsonp) {
                    output.write(");".getBytes("US-ASCII"));
                }
            }
        }
    }

    private static class StatusResponse
    implements HttpResponse {
        private final int code;
        private final long lastModified;
        @CheckForNull
        private final Long expires;

        public StatusResponse(int code, long lastModified, @CheckForNull Long expires) {
            this.code = code;
            this.lastModified = lastModified;
            this.expires = expires;
        }

        public void generateResponse(StaplerRequest2 req, StaplerResponse2 resp, Object node) throws IOException, ServletException {
            resp.setStatus(this.code);
            if (this.expires == null) {
                resp.setHeader(MetricsRootAction.CACHE_CONTROL, MetricsRootAction.NO_CACHE);
            } else {
                resp.setHeader(MetricsRootAction.CACHE_CONTROL, String.format(MetricsRootAction.MAX_AGE, TimeUnit.MILLISECONDS.toSeconds(this.expires - System.currentTimeMillis())));
                resp.setDateHeader("Expires", this.expires.longValue());
            }
            resp.setDateHeader("Last-Modified", this.lastModified);
        }
    }

    private class MetricsResponse
    implements HttpResponse {
        private final MetricRegistry registry;

        private MetricsResponse(MetricRegistry registry) {
            this.registry = registry;
        }

        public void generateResponse(StaplerRequest2 req, StaplerResponse2 resp, Object node) throws IOException, ServletException {
            boolean jsonp = StringUtils.isNotBlank((CharSequence)req.getParameter("callback"));
            String jsonpCallback = (String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("callback"), (CharSequence)"callback");
            String prefix = Util.fixEmptyAndTrim((String)req.getParameter("prefix"));
            String postfix = Util.fixEmptyAndTrim((String)req.getParameter("postfix"));
            resp.setHeader(MetricsRootAction.CACHE_CONTROL, MetricsRootAction.NO_CACHE);
            resp.setContentType(jsonp ? MetricsRootAction.JSONP_CONTENT_TYPE : MetricsRootAction.JSON_CONTENT_TYPE);
            resp.setStatus(200);
            try (ServletOutputStream output = resp.getOutputStream();){
                if (jsonp) {
                    output.write(jsonpCallback.getBytes("US-ASCII"));
                    output.write("(".getBytes("US-ASCII"));
                }
                output.write(MetricsRootAction.getWriter(MetricsRootAction.this.metricsMapper, (HttpServletRequest)req).writeValueAsBytes(prefix == null && postfix == null ? this.registry : new NameRewriterMetricRegistry(prefix, this.registry, postfix)));
                if (jsonp) {
                    output.write(");".getBytes("US-ASCII"));
                }
            }
        }
    }

    @Extension
    public static class Sampler
    extends PeriodicWork {
        private static final Set<String> METRIC_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("gauges", "counters", "histograms", "meters", "timers")));
        private static final int SIZE = Integer.getInteger(MetricsRootAction.class.getName() + ".Sampler.SIZE", 128);
        private final ExponentialLeakyBucket<Sample> bucket = new ExponentialLeakyBucket(Math.max(1, SIZE), 0.005);
        private final ObjectMapper mapper = new ObjectMapper();
        private int averageSize = 8192;

        public Sampler() {
            this.mapper.registerModule((Module)new MetricsModule(RATE_UNIT, DURATION_UNIT, false));
        }

        private static JsonNode renameFields(JsonNode json, String prefix, String postfix) {
            if (prefix == null && postfix == null || !json.isObject()) {
                return json;
            }
            ObjectNode result = JsonNodeFactory.instance.objectNode();
            Iterator fieldIterator = json.fields();
            while (fieldIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldIterator.next();
                result.set(MetricRegistry.name((String)prefix, (String[])new String[]{(String)field.getKey(), postfix}), (JsonNode)field.getValue());
            }
            return result;
        }

        private static JsonNode rewrite(JsonNode json, String prefix, String postfix) {
            if (prefix == null && postfix == null || !json.isObject()) {
                return json;
            }
            ObjectNode result = JsonNodeFactory.instance.objectNode();
            Iterator i = json.fields();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String fieldName = (String)entry.getKey();
                if (METRIC_FIELD_NAMES.contains(fieldName)) {
                    result.set(fieldName, Sampler.renameFields((JsonNode)entry.getValue(), prefix, postfix));
                    continue;
                }
                result.set(fieldName, (JsonNode)entry.getValue());
            }
            return result;
        }

        public Map<Date, Object> sample() {
            TreeMap<Date, Object> result = new TreeMap<Date, Object>();
            ObjectReader reader = this.mapper.reader(new JsonNodeFactory(false));
            for (Sample s : this.bucket.values()) {
                JsonNode value = s.getValue(reader);
                if (value == null) continue;
                result.put(s.getTime(), value);
            }
            return result;
        }

        public Map<Date, Object> sample(String prefix, String postfix) {
            TreeMap<Date, Object> result = new TreeMap<Date, Object>();
            ObjectReader reader = this.mapper.reader(new JsonNodeFactory(false));
            for (Sample s : this.bucket.values()) {
                JsonNode value = s.getValue(reader);
                if (value == null) continue;
                result.put(s.getTime(), Sampler.rewrite(value, prefix, postfix));
            }
            return result;
        }

        public static boolean isEnabled() {
            return SIZE <= 0;
        }

        public long getRecurrencePeriod() {
            return Sampler.isEnabled() ? TimeUnit.SECONDS.toMillis(30L) : TimeUnit.DAYS.toMillis(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() throws Exception {
            if (Sampler.isEnabled()) {
                ObjectWriter writer = this.mapper.writer();
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream(this.averageSize + 1024);
                     GZIPOutputStream gzos = new GZIPOutputStream(baos);){
                    writer.writeValue((OutputStream)gzos, (Object)Metrics.metricRegistry());
                }
                byte[] compressedBytes = baos.toByteArray();
                this.averageSize = Math.max(8192, (7 * this.averageSize + compressedBytes.length) / 8);
                this.bucket.add(new Sample(System.currentTimeMillis(), compressedBytes));
            }
        }

        @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
        @Restricted(value={DoNotUse.class})
        public static void dynamicInstallHack() {
            PeriodicWork p;
            VersionNumber version;
            if (Jenkins.getInstance().getInitLevel() == InitMilestone.COMPLETED && (version = Jenkins.getVersion()) != null && version.isOlderThan(new VersionNumber("2.129")) && (p = (PeriodicWork)ExtensionList.lookup(PeriodicWork.class).get(Sampler.class)) != null) {
                Timer.get().scheduleAtFixedRate((Runnable)p, p.getInitialDelay(), p.getRecurrencePeriod(), TimeUnit.MILLISECONDS);
            }
        }

        public static class Sample {
            private final long t;
            @NonNull
            private final byte[] v;

            public Sample(long t, @NonNull byte[] v) {
                this.t = t;
                this.v = v;
            }

            @NonNull
            public Date getTime() {
                return new Date(this.t);
            }

            @CheckForNull
            public JsonNode getValue(@NonNull ObjectReader reader) {
                JsonNode jsonNode;
                GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(this.v));
                try {
                    jsonNode = reader.readTree((InputStream)gzis);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            gzis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (JsonProcessingException e) {
                        return null;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                gzis.close();
                return jsonNode;
            }
        }
    }

    private class MetricsHistoryResponse
    implements HttpResponse {
        private MetricsHistoryResponse() {
        }

        public void generateResponse(StaplerRequest2 req, StaplerResponse2 resp, Object node) throws IOException, ServletException {
            boolean jsonp = StringUtils.isNotBlank((CharSequence)req.getParameter("callback"));
            String jsonpCallback = (String)StringUtils.defaultIfBlank((CharSequence)req.getParameter("callback"), (CharSequence)"callback");
            String prefix = Util.fixEmptyAndTrim((String)req.getParameter("prefix"));
            String postfix = Util.fixEmptyAndTrim((String)req.getParameter("postfix"));
            resp.setHeader(MetricsRootAction.CACHE_CONTROL, MetricsRootAction.NO_CACHE);
            resp.setContentType(jsonp ? MetricsRootAction.JSONP_CONTENT_TYPE : MetricsRootAction.JSON_CONTENT_TYPE);
            resp.setStatus(200);
            try (ServletOutputStream output = resp.getOutputStream();){
                Sampler sampler;
                if (jsonp) {
                    output.write(jsonpCallback.getBytes("US-ASCII"));
                    output.write("(".getBytes("US-ASCII"));
                }
                Map<Date, Object> sample = (sampler = (Sampler)((Object)ExtensionList.lookup(PeriodicWork.class).get(Sampler.class))) == null ? null : (prefix == null && postfix == null ? sampler.sample() : sampler.sample(prefix, postfix));
                output.write(MetricsRootAction.getWriter(MetricsRootAction.this.metricsMapper, (HttpServletRequest)req).writeValueAsBytes(sample));
                if (jsonp) {
                    output.write(");".getBytes("US-ASCII"));
                }
            }
        }
    }

    private static class PingResponse
    implements HttpResponse {
        private static final String CONTENT = "pong";

        private PingResponse() {
        }

        public void generateResponse(StaplerRequest2 req, StaplerResponse2 resp, Object node) throws IOException, ServletException {
            resp.setStatus(200);
            resp.setHeader(MetricsRootAction.CACHE_CONTROL, MetricsRootAction.NO_CACHE);
            resp.setContentType(MetricsRootAction.PLAIN_TEXT_CONTENT_TYPE);
            try (PrintWriter writer = resp.getWriter();){
                writer.println(CONTENT);
            }
        }
    }

    private static class ThreadDumpResponse
    implements HttpResponse {
        private final ThreadDump threadDump;

        public ThreadDumpResponse(ThreadDump threadDump) {
            this.threadDump = threadDump;
        }

        public void generateResponse(StaplerRequest2 req, StaplerResponse2 resp, Object node) throws IOException, ServletException {
            resp.setStatus(200);
            resp.setHeader(MetricsRootAction.CACHE_CONTROL, MetricsRootAction.NO_CACHE);
            resp.setContentType(MetricsRootAction.PLAIN_TEXT_CONTENT_TYPE);
            try (ServletOutputStream output = resp.getOutputStream();){
                this.threadDump.dump((OutputStream)output);
            }
        }
    }
}

