// CHECKSTYLE:OFF

package jenkins.metrics.api;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code MetricsAccessKey.invalidAccessKey}: {@code Invalid/unknown
     * access key: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid/unknown access key: {0}}
     */
    public static String MetricsAccessKey_invalidAccessKey(Object arg0) {
        return holder.format("MetricsAccessKey.invalidAccessKey", arg0);
    }

    /**
     * Key {@code MetricsAccessKey.invalidAccessKey}: {@code Invalid/unknown
     * access key: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid/unknown access key: {0}}
     */
    public static Localizable _MetricsAccessKey_invalidAccessKey(Object arg0) {
        return new Localizable(holder, "MetricsAccessKey.invalidAccessKey", arg0);
    }

    /**
     * Key {@code Metrics.ViewPermission.Description}: {@code This permission
     * grants read-only access to the Metrics servlet. Please be aware that
     * potentially sensitive information in your stack trace, such as job
     * names, will be exposed to a wider audience by granting this
     * permission.}.
     * 
     * @return
     *     {@code This permission grants read-only access to the Metrics servlet.
     *     Please be aware that potentially sensitive information in your stack
     *     trace, such as job names, will be exposed to a wider audience by
     *     granting this permission.}
     */
    public static String Metrics_ViewPermission_Description() {
        return holder.format("Metrics.ViewPermission.Description");
    }

    /**
     * Key {@code Metrics.ViewPermission.Description}: {@code This permission
     * grants read-only access to the Metrics servlet. Please be aware that
     * potentially sensitive information in your stack trace, such as job
     * names, will be exposed to a wider audience by granting this
     * permission.}.
     * 
     * @return
     *     {@code This permission grants read-only access to the Metrics servlet.
     *     Please be aware that potentially sensitive information in your stack
     *     trace, such as job names, will be exposed to a wider audience by
     *     granting this permission.}
     */
    public static Localizable _Metrics_ViewPermission_Description() {
        return new Localizable(holder, "Metrics.ViewPermission.Description");
    }

    /**
     * Key {@code Metrics.afterExtensionsAugmented}: {@code Registering
     * metric provider and health check provider extensions}.
     * 
     * @return
     *     {@code Registering metric provider and health check provider
     *     extensions}
     */
    public static String Metrics_afterExtensionsAugmented() {
        return holder.format("Metrics.afterExtensionsAugmented");
    }

    /**
     * Key {@code Metrics.afterExtensionsAugmented}: {@code Registering
     * metric provider and health check provider extensions}.
     * 
     * @return
     *     {@code Registering metric provider and health check provider
     *     extensions}
     */
    public static Localizable _Metrics_afterExtensionsAugmented() {
        return new Localizable(holder, "Metrics.afterExtensionsAugmented");
    }

    /**
     * Key {@code queued}: {@code Queued {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Queued {0}}
     */
    public static String queued(Object arg0) {
        return holder.format("queued", arg0);
    }

    /**
     * Key {@code queued}: {@code Queued {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Queued {0}}
     */
    public static Localizable _queued(Object arg0) {
        return new Localizable(holder, "queued", arg0);
    }

    /**
     * Key {@code MetricsAccessKey.displayName}: {@code Metrics access key}.
     * 
     * @return
     *     {@code Metrics access key}
     */
    public static String MetricsAccessKey_displayName() {
        return holder.format("MetricsAccessKey.displayName");
    }

    /**
     * Key {@code MetricsAccessKey.displayName}: {@code Metrics access key}.
     * 
     * @return
     *     {@code Metrics access key}
     */
    public static Localizable _MetricsAccessKey_displayName() {
        return new Localizable(holder, "MetricsAccessKey.displayName");
    }

    /**
     * Key {@code Metrics.HealthCheckPermission.Description}: {@code This
     * permission grants access to the health check functionality of the
     * Metrics servlet. Please be aware that depending on the nature of the
     * health checks in your system,this could be abused to deliver a denial
     * of service attack if the credentials of a user with this permission
     * become compromised.}.
     * 
     * @return
     *     {@code This permission grants access to the health check functionality
     *     of the Metrics servlet. Please be aware that depending on the nature
     *     of the health checks in your system,this could be abused to deliver a
     *     denial of service attack if the credentials of a user with this
     *     permission become compromised.}
     */
    public static String Metrics_HealthCheckPermission_Description() {
        return holder.format("Metrics.HealthCheckPermission.Description");
    }

    /**
     * Key {@code Metrics.HealthCheckPermission.Description}: {@code This
     * permission grants access to the health check functionality of the
     * Metrics servlet. Please be aware that depending on the nature of the
     * health checks in your system,this could be abused to deliver a denial
     * of service attack if the credentials of a user with this permission
     * become compromised.}.
     * 
     * @return
     *     {@code This permission grants access to the health check functionality
     *     of the Metrics servlet. Please be aware that depending on the nature
     *     of the health checks in your system,this could be abused to deliver a
     *     denial of service attack if the credentials of a user with this
     *     permission become compromised.}
     */
    public static Localizable _Metrics_HealthCheckPermission_Description() {
        return new Localizable(holder, "Metrics.HealthCheckPermission.Description");
    }

    /**
     * Key {@code Metrics.PermissionGroup}: {@code Metrics}.
     * 
     * @return
     *     {@code Metrics}
     */
    public static String Metrics_PermissionGroup() {
        return holder.format("Metrics.PermissionGroup");
    }

    /**
     * Key {@code Metrics.PermissionGroup}: {@code Metrics}.
     * 
     * @return
     *     {@code Metrics}
     */
    public static Localizable _Metrics_PermissionGroup() {
        return new Localizable(holder, "Metrics.PermissionGroup");
    }

    /**
     * Key {@code Metrics.ThreadDumpPermission.Description}: {@code This
     * permission grants read-only access to the thread dump functionality of
     * the Metrics servlet. Please be aware that potentially sensitive
     * information in your stack trace, such as job names, will be exposed to
     * users with this permission.}.
     * 
     * @return
     *     {@code This permission grants read-only access to the thread dump
     *     functionality of the Metrics servlet. Please be aware that potentially
     *     sensitive information in your stack trace, such as job names, will be
     *     exposed to users with this permission.}
     */
    public static String Metrics_ThreadDumpPermission_Description() {
        return holder.format("Metrics.ThreadDumpPermission.Description");
    }

    /**
     * Key {@code Metrics.ThreadDumpPermission.Description}: {@code This
     * permission grants read-only access to the thread dump functionality of
     * the Metrics servlet. Please be aware that potentially sensitive
     * information in your stack trace, such as job names, will be exposed to
     * users with this permission.}.
     * 
     * @return
     *     {@code This permission grants read-only access to the thread dump
     *     functionality of the Metrics servlet. Please be aware that potentially
     *     sensitive information in your stack trace, such as job names, will be
     *     exposed to users with this permission.}
     */
    public static Localizable _Metrics_ThreadDumpPermission_Description() {
        return new Localizable(holder, "Metrics.ThreadDumpPermission.Description");
    }

}
