/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.api;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.metrics.api.HealthCheckProvider;
import net.jcip.annotations.GuardedBy;

class HealthCheckProviderListener
extends ExtensionListListener {
    private static final Logger LOGGER = Logger.getLogger(HealthCheckProviderListener.class.getName());
    @GuardedBy(value="self")
    private final IdentityHashMap<HealthCheckProvider, Void> registered = new IdentityHashMap();
    private final ExtensionList<HealthCheckProvider> extensionList;
    private final HealthCheckRegistry registry;

    private HealthCheckProviderListener(ExtensionList<HealthCheckProvider> extensionList, HealthCheckRegistry registry) {
        this.extensionList = extensionList;
        this.registry = registry;
    }

    public static void attach(HealthCheckRegistry registry) {
        HealthCheckProviderListener listener = new HealthCheckProviderListener((ExtensionList<HealthCheckProvider>)ExtensionList.lookup(HealthCheckProvider.class), registry);
        listener.onChange();
        listener.extensionList.addListener((ExtensionListListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange() {
        IdentityHashMap<HealthCheckProvider, Void> identityHashMap = this.registered;
        synchronized (identityHashMap) {
            for (HealthCheckProvider p : this.extensionList) {
                if (this.registered.containsKey(p)) continue;
                LOGGER.log(Level.FINER, "Registering health check provider {0} (type {1})", new Object[]{p, p.getClass()});
                Map<String, HealthCheck> healthChecks = p.getHealthChecks();
                for (Map.Entry<String, HealthCheck> c : healthChecks.entrySet()) {
                    this.registry.register(c.getKey(), c.getValue());
                }
                LOGGER.log(Level.FINER, "Registered health check provider {0} (type {1}) with {2} checks: {3}", new Object[]{p, p.getClass(), healthChecks.size(), healthChecks.keySet()});
                this.registered.put(p, null);
            }
        }
    }
}

