/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.Extension;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RhodeCode
extends HgBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public RhodeCode(String url) throws MalformedURLException {
        super(url);
    }

    @Override
    public URL getChangeSetLink(MercurialChangeSet changeSet) throws IOException {
        this.current = changeSet;
        return new URL(this.getUrl(), "changeset/" + changeSet.getNode());
    }

    @Override
    public URL getFileLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "files/" + this.current.getNode() + "/" + path);
    }

    @Override
    public URL getDiffLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "changeset/" + this.current.getNode() + "#C" + path.replace("/", "-"));
    }

    @Extension
    public static class DescriptorImpl
    extends HgBrowser.HgBrowserDescriptor {
        public String getDisplayName() {
            return "rhodecode";
        }

        @Override
        public FormValidation doCheckUrl(@QueryParameter String url) {
            return this._doCheckUrl(url);
        }
    }
}

