/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial.browser;

import hudson.Extension;
import hudson.plugins.mercurial.MercurialChangeSet;
import hudson.plugins.mercurial.browser.HgBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class HgWeb
extends HgBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public HgWeb(String url) throws MalformedURLException {
        super(url);
    }

    @Override
    public URL getChangeSetLink(MercurialChangeSet changeSet) throws IOException {
        this.current = changeSet;
        return new URL(this.getUrl(), "rev/" + changeSet.getShortNode());
    }

    @Override
    public URL getFileLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "file/" + this.current.getShortNode() + "/" + path);
    }

    @Override
    public URL getDiffLink(String path) throws MalformedURLException {
        this.checkCurrentIsNotNull();
        return new URL(this.getUrl(), "diff/" + this.current.getShortNode() + "/" + path);
    }

    @Extension
    public static class DescriptorImpl
    extends HgBrowser.HgBrowserDescriptor {
        public String getDisplayName() {
            return "hgweb";
        }

        @Override
        public FormValidation doCheckUrl(@QueryParameter String url) {
            return this._doCheckUrl(url);
        }
    }
}

