/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.mercurial;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.mercurial.MercurialInstallation;
import hudson.plugins.mercurial.MercurialSCM;
import hudson.plugins.mercurial.Messages;
import hudson.remoting.VirtualChannel;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.ini4j.Ini;

public class HgExe
implements AutoCloseable {
    private final ArgumentListBuilder base;
    private final ArgumentListBuilder baseNoDebug;
    private final EnvVars env;
    public final Launcher launcher;
    public final Node node;
    public final TaskListener listener;
    private final Capability capability;
    private final FilePath sshPrivateKey;
    private static final Pattern NODEID_PATTERN = Pattern.compile("[0-9a-f]{40}");
    private static final Pattern REVISION_NUMBER_PATTERN = Pattern.compile("[0-9]+");

    @Deprecated
    public HgExe(MercurialSCM scm, Launcher launcher, AbstractBuild build, TaskListener listener) throws IOException, InterruptedException {
        this(MercurialSCM.findInstallation(scm.getInstallation()), scm.getCredentials((Job<?, ?>)build.getProject(), build.getEnvironment(listener)), launcher, build.getBuiltOn(), listener, build.getEnvironment(listener));
    }

    @Deprecated
    public HgExe(MercurialSCM scm, Launcher launcher, Node node, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        this(MercurialSCM.findInstallation(scm.getInstallation()), null, launcher, node, listener, env);
    }

    public HgExe(@CheckForNull MercurialInstallation inst, @CheckForNull StandardUsernameCredentials credentials, Launcher launcher, Node node, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        this.base = HgExe.findHgExe(inst, credentials, node, listener, true);
        this.baseNoDebug = HgExe.findHgExe(inst, credentials, node, listener, false);
        if (credentials instanceof SSHUserPrivateKey) {
            FilePath slaveRoot;
            SSHUserPrivateKey cc = (SSHUserPrivateKey)credentials;
            List keys = cc.getPrivateKeys();
            if (keys.isEmpty()) {
                throw new IOException("No private key available");
            }
            if (keys.size() > 1) {
                throw new IOException("Multiple private keys found.");
            }
            byte[] keyData = ((String)keys.get(0)).getBytes(StandardCharsets.US_ASCII);
            Secret passphrase = cc.getPassphrase();
            if (passphrase != null && passphrase.getPlainText().length() > 0) {
                try {
                    KeyPair kp = KeyPair.load((JSch)new JSch(), (byte[])keyData, null);
                    if (!kp.decrypt(passphrase.getPlainText())) {
                        throw new IOException("Passphrase did not decrypt SSH private key");
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    kp.writePrivateKey((OutputStream)baos);
                    keyData = baos.toByteArray();
                }
                catch (JSchException x) {
                    throw new IOException("Did not manage to decrypt SSH private key: " + String.valueOf((Object)x), x);
                }
            }
            if ((slaveRoot = node.getRootPath()) == null) {
                throw new IOException(node.getDisplayName() + " is offline");
            }
            this.sshPrivateKey = slaveRoot.createTempFile("jenkins-mercurial", ".sshkey");
            this.sshPrivateKey.chmod(384);
            this.sshPrivateKey.act((FilePath.FileCallable)new DeleteOnExit());
            try (OutputStream os = this.sshPrivateKey.write();){
                os.write(keyData);
            }
            block7: for (ArgumentListBuilder b : new ArgumentListBuilder[]{this.base, this.baseNoDebug}) {
                String sshAuthOpts = String.format(" -i %s -l %s", this.sshPrivateKey.getRemote(), cc.getUsername());
                List args = b.toList();
                for (int i = 0; i < args.size() - 1; ++i) {
                    if (!((String)args.get(i)).equals("--config") || !((String)args.get(i + 1)).startsWith("ui.ssh=")) continue;
                    b.add("--config");
                    b.addMasked((String)args.get(i + 1) + sshAuthOpts);
                    continue block7;
                }
                b.add("--config");
                b.addMasked("ui.ssh=ssh" + sshAuthOpts);
            }
        } else {
            this.sshPrivateKey = null;
        }
        this.node = node;
        this.env = env;
        env.put("HGPLAIN", "true");
        this.launcher = launcher;
        this.listener = listener;
        this.capability = Capability.get(this);
    }

    @Override
    public void close() throws IOException, InterruptedException {
        if (this.sshPrivateKey != null) {
            this.sshPrivateKey.delete();
        }
    }

    private static ArgumentListBuilder findHgExe(@CheckForNull MercurialInstallation inst, @CheckForNull StandardUsernameCredentials credentials, Node node, TaskListener listener, boolean allowDebug) throws IOException, InterruptedException {
        ArgumentListBuilder b = new ArgumentListBuilder();
        if (inst == null) {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                throw new IOException("Jenkins instance is not ready");
            }
            b.add(((MercurialSCM.DescriptorImpl)jenkins.getDescriptorByType(MercurialSCM.DescriptorImpl.class)).getHgExe());
        } else {
            String config;
            String toolHome = inst.forNode(node, listener).getHome();
            if (toolHome == null) {
                throw new IOException("Cannot determine tool home for " + String.valueOf((Object)inst));
            }
            b.add(inst.executableWithSubstitution(toolHome));
            if (allowDebug && inst.getDebug()) {
                b.add("--debug");
            }
            if ((config = inst.getConfig()) != null) {
                for (Map.Entry entry : new Ini((Reader)new StringReader(config)).entrySet()) {
                    String sectionName = (String)entry.getKey();
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        b.add(new String[]{"--config", sectionName + "." + (String)entry2.getKey() + "=" + (String)entry2.getValue()});
                    }
                }
            }
        }
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            b.add(new String[]{"--config", "auth.jenkins.prefix=*", "--config"});
            b.addMasked("auth.jenkins.username=" + upc.getUsername());
            b.add("--config");
            b.addMasked("auth.jenkins.password=" + upc.getPassword().getPlainText());
            b.add(new String[]{"--config", "auth.jenkins.schemes=http https"});
        } else if (credentials != null && !(credentials instanceof SSHUserPrivateKey)) {
            throw new IOException("Support for credentials currently limited to username/password and SSH private key: " + CredentialsNameProvider.name((Credentials)credentials));
        }
        return b;
    }

    public Launcher.ProcStarter launch(ArgumentListBuilder args) {
        return this.launcher.launch().cmds(args).stdout(this.listener).envs((Map)this.env);
    }

    public static int joinWithPossibleTimeout(Launcher.ProcStarter proc, boolean useTimeout, TaskListener listener) throws IOException, InterruptedException {
        return useTimeout ? proc.start().joinWithTimeout(3600L, TimeUnit.SECONDS, listener) : proc.join();
    }

    public ArgumentListBuilder seed(boolean allowDebug) {
        return (allowDebug ? this.base : this.baseNoDebug).clone();
    }

    @Deprecated
    public Launcher.ProcStarter pull() {
        return this.run("pull");
    }

    @Deprecated
    public Launcher.ProcStarter clone(String ... args) {
        return this.launch(this.seed(true).add("clone").add(args));
    }

    public Launcher.ProcStarter bundleAll(String file) {
        return this.run("bundle", "--all", file);
    }

    public Launcher.ProcStarter bundle(Collection<String> bases, String file) {
        ArgumentListBuilder args = this.seed(true).add("bundle");
        for (String head : bases) {
            args.add(new String[]{"--base", head});
        }
        args.add(file);
        return this.launch(args);
    }

    public Launcher.ProcStarter init(FilePath path) {
        return this.run("init", path.getRemote());
    }

    public Launcher.ProcStarter unbundle(String bundleFile) {
        return this.run("unbundle", bundleFile);
    }

    public Launcher.ProcStarter cleanAll() {
        return this.run("--config", "extensions.purge=", "clean", "--all");
    }

    public Launcher.ProcStarter run(String ... args) {
        return this.launch(this.seed(true).add(args));
    }

    @Deprecated
    public Launcher.ProcStarter run(ArgumentListBuilder args) {
        return this.launch(this.seed(true).add(args.toCommandArray()));
    }

    public Set<String> heads(FilePath repo, boolean useTimeout) throws IOException, InterruptedException {
        if (this.capability.headsIn15 == null) {
            try {
                Set<String> output = this.heads(repo, useTimeout, true);
                this.capability.headsIn15 = true;
                return output;
            }
            catch (AbortException x) {
                Set<String> output = this.heads(repo, useTimeout, false);
                this.capability.headsIn15 = false;
                return output;
            }
        }
        return this.heads(repo, useTimeout, this.capability.headsIn15);
    }

    private Set<String> heads(FilePath repo, boolean useTimeout, boolean usingHg15Syntax) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"heads", "--template", "{node}\\n"});
        if (usingHg15Syntax) {
            args.add(new String[]{"--topo", "--closed"});
        }
        String output = this.popen(repo, this.listener, useTimeout, args);
        LinkedHashSet<String> heads = new LinkedHashSet<String>(Arrays.asList(output.split("\n")));
        heads.remove("");
        return heads;
    }

    @CheckForNull
    public String tip(FilePath repository, @Nullable String rev) throws IOException, InterruptedException {
        String id = this.popen(repository, this.listener, false, new ArgumentListBuilder(new String[]{"log", "--rev", rev != null ? rev : ".", "--template", "{node}"}));
        if (!NODEID_PATTERN.matcher(id).matches()) {
            this.listener.error("Expected to get an id but got '" + id + "' instead.");
            return null;
        }
        return id;
    }

    @CheckForNull
    public String tipNumber(FilePath repository, @Nullable String rev) throws IOException, InterruptedException {
        String id = this.popen(repository, this.listener, false, new ArgumentListBuilder(new String[]{"log", "--rev", rev != null ? rev : ".", "--template", "{rev}"}));
        if (!REVISION_NUMBER_PATTERN.matcher(id).matches()) {
            this.listener.error(Messages.HgExe_expected_to_get_a_revision_number_but_got_instead(id));
            return null;
        }
        return id;
    }

    @CheckForNull
    public String branch(FilePath repository, @CheckForNull String rev) throws IOException, InterruptedException {
        String branch;
        ArgumentListBuilder builder = new ArgumentListBuilder(new String[]{"id", "--branch"});
        if (rev != null) {
            builder.add(new String[]{"--rev", rev});
        }
        if ((branch = this.popen(repository, this.listener, false, builder).trim()).isEmpty()) {
            this.listener.error(Messages.HgExe_expected_to_get_a_branch_name_but_got_nothing());
            return null;
        }
        return branch;
    }

    @CheckForNull
    public String version() throws IOException, InterruptedException {
        String version = this.popen(null, this.listener, false, new ArgumentListBuilder(new String[]{"version"}));
        if (version.isEmpty()) {
            this.listener.error(Messages.HgExe_expected_to_get_hg_version_name_but_got_nothing());
            return null;
        }
        Matcher m = Pattern.compile("^Mercurial Distributed SCM [(]version ([0-9][^)]*)[)]$", 8).matcher(version);
        if (!m.find() || m.groupCount() < 1) {
            this.listener.getLogger().print(version);
            this.listener.error(Messages.HgExe_cannot_extract_hg_version());
            return null;
        }
        return m.group(1);
    }

    public String config(FilePath repository, String name) throws IOException, InterruptedException {
        return this.popen(repository, this.listener, false, new ArgumentListBuilder(new String[]{"showconfig", name})).trim();
    }

    @NonNull
    public String popen(FilePath repository, TaskListener listener, boolean useTimeout, ArgumentListBuilder args) throws IOException, InterruptedException {
        args = this.seed(false).add(args.toCommandArray());
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        if (HgExe.joinWithPossibleTimeout(this.launch(args).pwd(repository).stdout((OutputStream)data), useTimeout, listener) == 0) {
            try {
                return data.toString(Charset.defaultCharset().name());
            }
            catch (UnsupportedCharsetException ex) {
                throw new IOException("Cannot perform a conversion using the default charset", ex);
            }
        }
        listener.error("Failed to run " + args.toStringWithQuote());
        listener.getLogger().write(data.toByteArray());
        throw new AbortException();
    }

    static boolean pathEquals(@NonNull String pathURL, @NonNull String pathAsInConfig) {
        if (pathAsInConfig.equals(pathURL)) {
            return true;
        }
        if ((pathAsInConfig + "/").equals(pathURL)) {
            return true;
        }
        if (pathAsInConfig.equals(pathURL + "/")) {
            return true;
        }
        if (pathURL.startsWith("file:/") && URI.create(pathURL).equals(new File(pathAsInConfig).toURI())) {
            return true;
        }
        return pathAsInConfig.startsWith("file:/") && URI.create(pathAsInConfig).equals(new File(pathURL).toURI());
    }

    private static final class DeleteOnExit
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        private DeleteOnExit() {
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            f.deleteOnExit();
            return null;
        }
    }

    private static final class Capability {
        volatile Boolean headsIn15;
        private static final Map<Node, Map<List<String>, Capability>> MAP = new WeakHashMap<Node, Map<List<String>, Capability>>();

        private Capability() {
        }

        static synchronized Capability get(HgExe hg) {
            List hgConfig;
            Capability cap;
            Map<List<String>, Capability> m = MAP.get(hg.node);
            if (m == null) {
                m = new HashMap<List<String>, Capability>();
                MAP.put(hg.node, m);
            }
            if ((cap = m.get(hgConfig = hg.seed(false).toList())) == null) {
                cap = new Capability();
                m.put(hgConfig, cap);
            }
            return cap;
        }
    }
}

